/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.openbp.common.generic.PrintNameProvider;
import org.openbp.common.generic.description.DescriptionObject;
import org.openbp.common.logger.LogUtil;
import org.openbp.common.property.PropertyAccessUtil;

public final class ToStringHelper {
    public static final int TOSTRING_QUALIFIED_CLASSNAME = 1;
    public static final int TOSTRING_ABBREVIATED_CLASSNAME = 2;
    public static final int TOSTRING_UNQUALIFIED_CLASSNAME = 4;
    public static final int HASHCODE = 8;
    private static int toStringFlags = 4;
    private static boolean shortInfo = true;
    private static String[] classNamePrefixes = new String[]{"org.openbp.", "org.openbp.common.", "java.lang.", "java.util."};

    private ToStringHelper() {
    }

    public static String toString(Object o) {
        return ToStringHelper.toString(o, (String[])null);
    }

    public static String toString(Object o, String property1) {
        return ToStringHelper.toString(o, new String[]{property1});
    }

    public static String toString(Object o, String property1, String property2) {
        return ToStringHelper.toString(o, new String[]{property1, property2});
    }

    public static String toString(Object o, String property1, String property2, String property3) {
        return ToStringHelper.toString(o, new String[]{property1, property2, property3});
    }

    public static String toString(Object o, String property1, String property2, String property3, String property4) {
        return ToStringHelper.toString(o, new String[]{property1, property2, property3, property4});
    }

    public static String toString(Object o, String property1, String property2, String property3, String property4, String property5) {
        return ToStringHelper.toString(o, new String[]{property1, property2, property3, property4, property5});
    }

    public static String toString(Object o, String property1, String property2, String property3, String property4, String property5, String property6) {
        return ToStringHelper.toString(o, new String[]{property1, property2, property3, property4, property5, property6});
    }

    private static StringBuffer buildObjectInfo(Object o) {
        int i;
        StringBuffer sb = new StringBuffer();
        if (o == null) {
            sb.append("(null)");
            return sb;
        }
        if (o instanceof Collection) {
            int r = 0;
            for (Object v : (Collection)o) {
                sb.append("[");
                sb.append(r++);
                sb.append("] = ");
                ToStringHelper.appendToStringOutput(sb, v);
            }
            return sb;
        }
        String className = o.getClass().getName();
        if ((toStringFlags & 2) != 0) {
            for (i = 0; i < classNamePrefixes.length; ++i) {
                if (!className.startsWith(classNamePrefixes[i])) continue;
                className = className.substring(classNamePrefixes[i].length());
                break;
            }
        } else if ((toStringFlags & 4) != 0 && (i = className.lastIndexOf(46)) > 0) {
            className = className.substring(i + 1);
        }
        sb.append(className);
        if ((toStringFlags & 8) != 0) {
            sb.append('@');
            sb.append(Integer.toHexString(o.hashCode()));
        }
        String name = null;
        if (o instanceof PrintNameProvider) {
            name = ((PrintNameProvider)o).getPrintName();
        } else if (o instanceof DescriptionObject) {
            name = ((DescriptionObject)o).getName();
        }
        if (name != null) {
            sb.append("(");
            sb.append(name);
            sb.append(")");
        }
        return sb;
    }

    public static String toString(Object o, String[] properties) {
        StringBuffer sb = ToStringHelper.buildObjectInfo(o);
        if (o != null && properties != null) {
            for (int i = 0; i < properties.length; ++i) {
                try {
                    Object value = PropertyAccessUtil.getProperty(o, properties[i]);
                    if (value == null) continue;
                    if (i == 0) {
                        sb.append(":");
                    } else {
                        sb.append(",");
                    }
                    sb.append(" ");
                    sb.append(properties[i]);
                    sb.append(" = ");
                    if (shortInfo) {
                        if (value instanceof Collection) {
                            value = ((Collection)value).iterator();
                        }
                    } else if (value instanceof Collection) {
                        value = "[collection size: " + ((Collection)value).size() + "]";
                    } else if (value instanceof Map) {
                        value = "[map size: " + ((Map)value).size() + "]";
                    }
                    if (value instanceof Iterator) {
                        int r = 0;
                        Iterator it = value;
                        while (it.hasNext()) {
                            Object v = it.next();
                            sb.append("[");
                            sb.append(r++);
                            sb.append("] = ");
                            ToStringHelper.appendToStringOutput(sb, v);
                        }
                        continue;
                    }
                    ToStringHelper.appendToStringOutput(sb, value);
                    continue;
                }
                catch (Exception e) {
                    LogUtil.warn(ToStringHelper.class, "Logging error: Error printing log object argument $0 of object of type $1.", properties[i], o.getClass().getName(), e);
                    if (i == 0) {
                        sb.append(":");
                    } else {
                        sb.append(",");
                    }
                    sb.append(" ");
                    sb.append(properties[i]);
                    sb.append(" = ");
                    sb.append("<ERROR>");
                }
            }
        }
        return sb.toString();
    }

    private static void appendToStringOutput(StringBuffer sb, Object o) {
        String s = o.toString();
        if (s.indexOf(10) >= 0) {
            sb.append(s);
        } else {
            boolean first = true;
            StringTokenizer st = new StringTokenizer(s, "\n");
            while (st.hasMoreTokens()) {
                if (!first) {
                    sb.append("\n    ");
                } else {
                    first = false;
                }
                sb.append(st.nextToken());
            }
        }
    }
}

