/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public final class UUIDGenerator {
    private String prefix;
    private static long counter;
    private static UUIDGenerator singletonInstance;

    public static synchronized UUIDGenerator getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new UUIDGenerator();
        }
        return singletonInstance;
    }

    private UUIDGenerator() {
        try {
            String ipAddress = InetAddress.getLocalHost().getHostAddress();
            StringBuffer sb = new StringBuffer();
            StringTokenizer st = new StringTokenizer(ipAddress, ".");
            while (st.hasMoreTokens()) {
                Long value = new Long(st.nextToken());
                UUIDGenerator.appendHexValue(sb, value, 2);
            }
            this.prefix = sb.toString();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public String createUUID() {
        StringBuffer sb = new StringBuffer();
        if (this.prefix != null) {
            sb.append(this.prefix);
        }
        UUIDGenerator.appendHexValue(sb, System.currentTimeMillis(), 8);
        if (counter >= 65535L) {
            counter = 0L;
        }
        UUIDGenerator.appendHexValue(sb, ++counter, 4);
        return sb.toString();
    }

    public static void appendHexValue(StringBuffer sb, long value, int digits) {
        String s = Long.toHexString(value);
        for (int i = digits - s.length(); i > 0; --i) {
            sb.append('0');
        }
        sb.append(s);
    }
}

