/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.common.util.observer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openbp.common.CollectionUtil;
import org.openbp.common.util.observer.EventObserver;
import org.openbp.common.util.observer.ObserverEvent;

public class EventObserverMgr {
    private Map eventTypesToObservers;
    private boolean eventsSuspended;
    private String[] supportedEventTypes;

    public String[] getPossibleEventTypes() {
        return this.supportedEventTypes;
    }

    public void setSupportedEventTypes(String[] supportedEventTypes) {
        this.supportedEventTypes = supportedEventTypes;
    }

    public void registerObserver(EventObserver observer, String[] eventTypes) {
        if (this.eventTypesToObservers == null) {
            this.eventTypesToObservers = new HashMap();
        }
        if (eventTypes == null || eventTypes.length == 0) {
            if (this.supportedEventTypes == null) {
                throw new IllegalArgumentException("Trying to register an observer for any event type, but no list of supported event types specified.");
            }
            eventTypes = this.supportedEventTypes;
        }
        for (int i = 0; i < eventTypes.length; ++i) {
            String eventType = eventTypes[i];
            ArrayList<EventObserver> observers = (ArrayList<EventObserver>)this.eventTypesToObservers.get(eventType);
            if (observers == null) {
                observers = new ArrayList<EventObserver>();
                this.eventTypesToObservers.put(eventType, observers);
            }
            if (observers.contains(observer)) continue;
            observers.add(observer);
        }
    }

    public void unregisterObserver(EventObserver observer) {
        if (this.eventTypesToObservers == null) {
            return;
        }
        Iterator it = this.eventTypesToObservers.values().iterator();
        while (it.hasNext()) {
            List observers = (List)it.next();
            CollectionUtil.removeReference(observers, observer);
            if (!observers.isEmpty()) continue;
            it.remove();
        }
        if (this.eventTypesToObservers.isEmpty()) {
            this.eventTypesToObservers = null;
        }
    }

    public boolean hasActiveObservers() {
        return this.eventTypesToObservers != null && !this.eventsSuspended;
    }

    public boolean hasActiveObservers(String eventType) {
        List observers;
        return this.eventTypesToObservers != null && !this.eventsSuspended && (observers = (List)this.eventTypesToObservers.get(eventType)) != null;
    }

    public boolean suspendObserverEvents() {
        boolean ret = this.eventsSuspended;
        this.eventsSuspended = true;
        return ret;
    }

    public void resumeObserverEvents() {
        this.eventsSuspended = false;
    }

    public void fireEvent(ObserverEvent event) {
        String eventType;
        List observers;
        if (this.eventTypesToObservers != null && !this.eventsSuspended && (observers = (List)this.eventTypesToObservers.get(eventType = event.getEventType())) != null) {
            int nObservers = observers.size();
            for (int i = 0; i < nObservers; ++i) {
                EventObserver observer = (EventObserver)observers.get(i);
                observer.observeEvent(event);
                if (event.shallSkipSubsequentObservers()) break;
            }
        }
    }
}

