package org.openbp.config;

import org.openbp.config.modelmgr.ClassPathModelMgrConfig;
import org.openbp.config.persistence.hibernate.PlainHibernateConfig;
import org.openbp.config.scheduler.QuartzProcessSchedulerConfig;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

/**
 * Spring configuration that wires a process server running processes in memory.
 */
@Configuration
@Import(
{
	PlainHibernateConfig.class,
	QuartzProcessSchedulerConfig.class,
	ClassPathModelMgrConfig.class
})
public class HibernateProcessServerConfig extends PersistentProcessServerConfigBase
{
}
