package org.openbp.config;

import org.openbp.config.modelmgr.ClassPathAndDatabaseModelMgrConfig;
import org.openbp.config.persistence.hibernate.PlainHibernateConfig;
import org.openbp.config.scheduler.QuartzProcessSchedulerConfig;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

/**
 * Spring configuration that wires a process server running processes in memory.
 */
@Configuration
@Import(
{
	PlainHibernateConfig.class,
	QuartzProcessSchedulerConfig.class,
	ClassPathAndDatabaseModelMgrConfig.class
})
public class HibernateProcessServerDatabaseModelConfig extends PersistentProcessServerConfigBase
{
}
