package org.openbp.config.persistence.hibernate;

import org.openbp.config.context.PersistedTokenConfigBase;
import org.openbp.server.persistence.PersistenceContextProvider;
import org.openbp.server.persistence.hibernate.HibernatePersistenceContextProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Spring configuration supporting plain (non-JPA) Hibernate-based token context management.
 * Supports saving and loading tokens to/from a database in order to support wait states, workflows and error recovery.
 */
@Configuration
public class PlainHibernateConfig extends PersistedTokenConfigBase
{
	@Bean
	public PersistenceContextProvider persistenceContextProvider()
	{
		// Also possible if you require information on running, uncommitted contexts (e. g. progress information),
		// use the session-aware persistant token context service.
		// return new SessionAwarePersistentTokenContextService();
		return new HibernatePersistenceContextProvider();
	}
}
