/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.server.persistence.hibernate;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.openbp.common.logger.LogUtil;
import org.openbp.server.persistence.BasicPersistenceContext;
import org.openbp.server.persistence.BasicPersistenceContextProvider;
import org.openbp.server.persistence.PersistenceContext;
import org.openbp.server.persistence.PersistenceCriterion;
import org.openbp.server.persistence.PersistenceException;
import org.openbp.server.persistence.PersistenceOrdering;
import org.openbp.server.persistence.PersistenceQuery;
import org.openbp.server.persistence.PersistentObjectBase;
import org.openbp.server.persistence.PersistentObjectNotFoundException;
import org.openbp.server.persistence.TransactionGuard;

public class HibernatePersistenceContext
extends BasicPersistenceContext {
    protected final SessionFactory sessionFactory;
    protected Session session;

    public HibernatePersistenceContext(SessionFactory sessionFactory, BasicPersistenceContextProvider provider) {
        super(provider);
        this.sessionFactory = sessionFactory;
    }

    public void release() {
        if (this.session != null) {
            try {
                LogUtil.debug(((Object)((Object)this)).getClass(), (String)"Closing Hibernate session $0.", (Object)this.session);
                if (this.session.isOpen()) {
                    this.session.close();
                }
                this.session = null;
            }
            catch (HibernateException e) {
                throw this.createLoggedException(e);
            }
        }
        super.release();
    }

    public boolean isPersistentObject(Object obj) {
        Class<?> entityClass = obj.getClass();
        Class beanClass = this.determineEntityClass(entityClass);
        return this.getHibernateSession().getSessionFactory().getClassMetadata(beanClass) != null;
    }

    public Object getObjectId(Object obj) throws PersistenceException {
        try {
            Serializable ident = null;
            if (this.getHibernateSession().contains(obj)) {
                ident = this.getHibernateSession().getIdentifier(obj);
            }
            return ident;
        }
        catch (HibernateException e) {
            throw this.createLoggedException(e);
        }
    }

    public Object merge(Object obj) throws PersistenceException {
        TransactionGuard tg = new TransactionGuard((PersistenceContext)this);
        try {
            Object object = obj = this.getHibernateSession().merge(obj);
            return object;
        }
        catch (HibernateException e) {
            tg.doCatch();
            throw this.createLoggedException(e);
        }
        finally {
            tg.doFinally();
        }
    }

    public Object refreshObject(Object obj) throws PersistenceException {
        if (obj != null) {
            TransactionGuard tg = new TransactionGuard((PersistenceContext)this);
            try {
                if (obj instanceof PersistentObjectBase) {
                    ((PersistentObjectBase)obj).flagAsUnloaded();
                }
                this.getHibernateSession().refresh(obj);
            }
            catch (UnresolvableObjectException e) {
                tg.doCatch();
                String msg = LogUtil.error(((Object)((Object)this)).getClass(), (String)"Persistence error.", (Object)((Object)e));
                throw new PersistentObjectNotFoundException(msg, (Throwable)e);
            }
            catch (HibernateException e) {
                tg.doCatch();
                throw this.createLoggedException(e);
            }
            finally {
                tg.doFinally();
            }
        }
        return obj;
    }

    public void evict(Object obj) throws PersistenceException {
        if (obj != null) {
            try {
                this.getHibernateSession().evict(obj);
            }
            catch (HibernateException e) {
                throw this.createLoggedException(e);
            }
        }
    }

    public Object findById(Object id, Class entityClass) throws PersistenceException {
        Class beanClass = this.determineEntityClass(entityClass);
        TransactionGuard tg = new TransactionGuard((PersistenceContext)this);
        try {
            Object ret;
            Object object = ret = this.getHibernateSession().get(beanClass, (Serializable)id);
            return object;
        }
        catch (HibernateException e) {
            tg.doCatch();
            throw this.createLoggedException(e);
        }
        finally {
            tg.doFinally();
        }
    }

    public Iterator runQuery(PersistenceQuery query) throws PersistenceException {
        TransactionGuard tg = new TransactionGuard((PersistenceContext)this);
        try {
            Class beanClass = this.determineEntityClass(query.getObjectClass());
            Criteria hc = this.getHibernateSession().createCriteria(beanClass);
            if (query.getMaxResults() > 0) {
                hc.setMaxResults(query.getMaxResults());
            }
            Iterator it = query.getOrderings();
            while (it.hasNext()) {
                PersistenceOrdering ordering = (PersistenceOrdering)it.next();
                Order ho = ordering.isAscending() ? Order.asc((String)ordering.getPropertyName()) : Order.desc((String)ordering.getPropertyName());
                hc.addOrder(ho);
            }
            it = query.getCriterions();
            while (it.hasNext()) {
                PersistenceCriterion criterion = (PersistenceCriterion)it.next();
                String property = criterion.getProperty();
                String operator = criterion.getOperator();
                Object value = criterion.getOperand();
                if ("eq".equals(operator)) {
                    hc = hc.add((Criterion)Restrictions.eq((String)property, (Object)value));
                    continue;
                }
                if ("eq-or-null".equals(operator)) {
                    hc = hc.add((Criterion)Restrictions.disjunction().add(Restrictions.isNull((String)property)).add((Criterion)Restrictions.eq((String)property, (Object)value)));
                    continue;
                }
                if ("neq".equals(operator)) {
                    hc = hc.add((Criterion)Restrictions.ne((String)property, (Object)value));
                    continue;
                }
                if ("gt".equals(operator)) {
                    hc = hc.add((Criterion)Restrictions.gt((String)property, (Object)value));
                    continue;
                }
                if ("gte".equals(operator)) {
                    hc = hc.add((Criterion)Restrictions.ge((String)property, (Object)value));
                    continue;
                }
                if ("lt".equals(operator)) {
                    hc = hc.add((Criterion)Restrictions.lt((String)property, (Object)value));
                    continue;
                }
                if ("lte".equals(operator)) {
                    hc = hc.add((Criterion)Restrictions.le((String)property, (Object)value));
                    continue;
                }
                if ("like".equals(operator)) {
                    hc = hc.add((Criterion)Restrictions.gt((String)property, (Object)value));
                    continue;
                }
                if ("null".equals(operator)) {
                    hc = hc.add(Restrictions.isNull((String)property));
                    continue;
                }
                if (!"alias".equals(operator)) continue;
                hc = hc.createAlias(property, (String)value);
            }
            List result = hc.list();
            Iterator iterator = result.iterator();
            return iterator;
        }
        catch (HibernateException e) {
            tg.doCatch();
            throw this.createLoggedException(e);
        }
        finally {
            tg.doFinally();
        }
    }

    public Object saveObject(Object o) throws PersistenceException {
        TransactionGuard tg = new TransactionGuard((PersistenceContext)this);
        try {
            this.getHibernateSession().saveOrUpdate(o);
            Object object = o;
            return object;
        }
        catch (HibernateException e) {
            tg.doCatch();
            throw this.createLoggedException(e);
        }
        finally {
            tg.doFinally();
        }
    }

    public void deleteObject(Object o) throws PersistenceException {
        TransactionGuard tg = new TransactionGuard((PersistenceContext)this);
        try {
            this.getHibernateSession().delete(o);
        }
        catch (HibernateException e) {
            tg.doCatch();
            throw this.createLoggedException(e);
        }
        finally {
            tg.doFinally();
        }
    }

    public int executeUpdateOrDelete(String sql) throws PersistenceException {
        TransactionGuard tg = new TransactionGuard((PersistenceContext)this);
        try {
            int count;
            SQLQuery query = this.getHibernateSession().createSQLQuery(sql);
            int n = count = query.executeUpdate();
            return n;
        }
        catch (HibernateException e) {
            tg.doCatch();
            throw this.createLoggedException(e);
        }
        finally {
            tg.doFinally();
        }
    }

    public Iterator executeSelect(String sql, int maxResults) throws PersistenceException {
        TransactionGuard tg = new TransactionGuard((PersistenceContext)this);
        try {
            SQLQuery query = this.getHibernateSession().createSQLQuery(sql);
            if (maxResults > 0) {
                query.setMaxResults(maxResults);
            }
            List root = query.list();
            Iterator iterator = root.iterator();
            return iterator;
        }
        catch (HibernateException e) {
            tg.doCatch();
            throw this.createLoggedException(e);
        }
        finally {
            tg.doFinally();
        }
    }

    public boolean isTransactionActive() throws PersistenceException {
        return this.getHibernateTransaction().isActive();
    }

    public void doBeginTransaction() throws PersistenceException {
        if (!this.getHibernateTransaction().isActive()) {
            LogUtil.trace(((Object)((Object)this)).getClass(), (String)"Beginning transaction.");
            this.getHibernateTransaction().begin();
        }
    }

    public void doRollbackTransaction() throws PersistenceException {
        if (this.getHibernateTransaction().isActive()) {
            LogUtil.trace(((Object)((Object)this)).getClass(), (String)"Rolling back transaction on.");
            try {
                this.getHibernateTransaction().rollback();
            }
            catch (HibernateException e) {
                throw this.createLoggedException(e);
            }
        }
    }

    public void doCommitTransaction() throws PersistenceException {
        if (this.getHibernateTransaction().isActive()) {
            LogUtil.trace(((Object)((Object)this)).getClass(), (String)"Committing transaction.");
            try {
                this.getHibernateSession().flush();
                this.getHibernateTransaction().commit();
                LogUtil.trace(((Object)((Object)this)).getClass(), (String)"Committed transaction.");
            }
            catch (HibernateException e) {
                throw this.createLoggedException(e);
            }
        }
    }

    public void flush() throws PersistenceException {
        try {
            this.getHibernateSession().flush();
        }
        catch (HibernateException e) {
            throw this.createLoggedException(e);
        }
    }

    public Session getHibernateSession() {
        if (this.session != null && !this.session.isOpen()) {
            LogUtil.debug(((Object)((Object)this)).getClass(), (String)"Hibernate session $0 was closed, going to open a new session.", (Object)this.session);
            this.session = null;
        }
        if (this.session == null) {
            this.session = this.sessionFactory.openSession();
            LogUtil.debug(((Object)((Object)this)).getClass(), (String)"Opened Hibernate session $0.", (Object)this.session);
        }
        return this.session;
    }

    private Transaction getHibernateTransaction() {
        return this.getHibernateSession() != null ? this.getHibernateSession().getTransaction() : null;
    }
}

