/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.server.persistence.hibernate;

import java.util.Iterator;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.PersistentClass;
import org.openbp.server.context.TokenContextImpl;
import org.openbp.server.context.WorkflowTaskImpl;
import org.openbp.server.model.modelmgr.DbModel;
import org.openbp.server.model.modelmgr.DbModelItem;
import org.openbp.server.persistence.BasicPersistenceContextProvider;
import org.openbp.server.persistence.PersistenceContext;
import org.openbp.server.persistence.PersistenceException;
import org.openbp.server.persistence.hibernate.HibernatePersistenceContext;

public class HibernatePersistenceContextProvider
extends BasicPersistenceContextProvider {
    protected transient SessionFactory sessionFactory;

    public void shutdown() {
        if (this.sessionFactory != null) {
            this.sessionFactory.close();
            this.sessionFactory = null;
        }
    }

    protected PersistenceContext createPersistenceContext() throws PersistenceException {
        if (this.sessionFactory == null) {
            this.sessionFactory = this.createSessionFactory();
        }
        return new HibernatePersistenceContext(this.sessionFactory, this);
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    protected SessionFactory createSessionFactory() throws PersistenceException {
        Configuration configuration = this.createHibernateConfiguration();
        try {
            return configuration.buildSessionFactory();
        }
        catch (HibernateException he) {
            throw new PersistenceException("Hibernate configuration problem:", (Throwable)he);
        }
    }

    public Configuration createHibernateConfiguration() {
        Configuration configuration = new Configuration();
        configuration.configure();
        HibernatePersistenceContextProvider.addOpenBPClassMappingsToConfiguration(configuration);
        return configuration;
    }

    public static void addOpenBPClassMappingsToConfiguration(Configuration configuration) {
        HibernatePersistenceContextProvider.addClassMappingToConfiguration(configuration, TokenContextImpl.class);
        HibernatePersistenceContextProvider.addClassMappingToConfiguration(configuration, WorkflowTaskImpl.class);
        HibernatePersistenceContextProvider.addClassMappingToConfiguration(configuration, DbModel.class);
        HibernatePersistenceContextProvider.addClassMappingToConfiguration(configuration, DbModelItem.class);
    }

    private static void addClassMappingToConfiguration(Configuration configuration, Class cls) {
        String className = cls.getName();
        Iterator it = configuration.getClassMappings();
        while (it.hasNext()) {
            PersistentClass pc = (PersistentClass)it.next();
            if (!pc.getClassName().equals(className)) continue;
            return;
        }
        configuration.addClass(cls);
    }
}

