/**
 * plugin.js
 *
 * Copyright 2013 Web Power, www.webpower.nl
 * @author Arjan Haverkamp
 */

/*jshint unused:false */
/*global tinymce:true */

tinymce.PluginManager.requireLangPack('codemirror');

tinymce.PluginManager.add('codemirror', function(editor, url) {

	function showSourceEditor() {
        
        editor.focus();
        editor.selection.collapse(true);
        
        // Insert caret marker
        if (editor.settings.codemirror.saveCursorPosition) {
            editor.selection.setContent('<span style="display: none;" class="CmCaReT">&#x0;</span>');
        }

        var dialodUrl=url + '/source.html';
		var config = {
   	    	title: "HTML source code",
   	    	size: 'large',
   	    	body: {
   	       		type: "panel",
   	       		items: [{
   	           		type: "htmlpanel",
   	           		html: "<iframe id=\"currentCodemirrorInstance\" src=\""+dialodUrl+"\" style=\"width:100%; height:528px;\" />"
   	       		}]
   	   		},
   	   		buttons: [
          		{
            		type: 'custom',
            		name: 'ok',
            		text: 'Ok',
            		disabled: false
          		},
          		{
            		type: 'custom',
            		name: 'close',
            		text: 'Cancel',
            		disabled: false
          		}
        	],
       		onAction: function (dialogApi, actionData) {
          		if (actionData.name === 'close') {
          			dialogApi.close();
          		}else if (actionData.name === 'ok') {
          			var doc = document.getElementById('currentCodemirrorInstance');
					doc.contentWindow.submit();
          			dialogApi.close();
          		}
        	}
   		};

		var win = editor.windowManager.open(config);

		if (editor.settings.codemirror.fullscreen) {
			win.fullscreen(true);
		}
	};

	// Add a button to the button bar
	editor.ui.registry.addButton('code', {
		title: 'Source code',
		icon: 'sourcecode',
		onAction: showSourceEditor
	});

	// Add a menu item to the tools menu
	editor.ui.registry.addMenuItem('code', {
		icon: 'sourcecode',
		text: 'Source code',
		context: 'tools',
		onAction: showSourceEditor
	});
});
