/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import controllers.I18nService;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import model.Database;
import model.DatabasePCM;
import org.opencompare.api.java.Feature;
import org.opencompare.api.java.PCM;
import org.opencompare.api.java.PCMContainer;
import org.opencompare.api.java.PCMFactory;
import org.opencompare.api.java.PCMMetadata;
import org.opencompare.api.java.Product;
import org.opencompare.api.java.impl.PCMFactoryImpl;
import org.opencompare.api.java.impl.io.KMFJSONExporter;
import org.opencompare.api.java.impl.io.KMFJSONLoader;
import org.opencompare.api.java.io.CSVExporter;
import org.opencompare.api.java.io.CSVLoader;
import org.opencompare.api.java.io.HTMLExporter;
import org.opencompare.api.java.io.HTMLLoader;
import org.opencompare.formalizer.extractor.CellContentInterpreter;
import org.opencompare.io.wikipedia.io.MediaWikiAPI;
import org.opencompare.io.wikipedia.io.WikiTextExporter;
import org.opencompare.io.wikipedia.io.WikiTextLoader;
import org.opencompare.io.wikipedia.io.WikiTextTemplateProcessor;
import org.opencompare.io.wikipedia.parser.CellContentExtractor;
import play.api.libs.json.JsArray;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsString;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json;
import play.data.DynamicForm;
import play.data.Form;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import scala.collection.JavaConversions;
import scala.collection.Map;
import scala.collection.Seq;

@Singleton
public class PCMAPI
extends Controller {
    private final PCMFactory pcmFactory = new PCMFactoryImpl();
    private final KMFJSONExporter jsonExporter = new KMFJSONExporter();
    private final CSVExporter csvExporter = new CSVExporter();
    private final HTMLExporter htmlExporter = new HTMLExporter();
    private final KMFJSONLoader jsonLoader = new KMFJSONLoader();
    private final WikiTextExporter wikiExporter = new WikiTextExporter(true);
    private final MediaWikiAPI mediaWikiAPI = new MediaWikiAPI("wikipedia.org");
    private final WikiTextTemplateProcessor wikitextTemplateProcessor = new WikiTextTemplateProcessor(this.mediaWikiAPI);
    private final WikiTextLoader miner = new WikiTextLoader(this.wikitextTemplateProcessor);
    private final CellContentInterpreter cellContentInterpreter = new CellContentInterpreter();
    @Inject
    private I18nService i18nService;

    private List<PCMContainer> loadWikitext(String language, String title) {
        String code = this.mediaWikiAPI.getWikitextFromTitle(language, title);
        List pcmContainers = this.miner.mine(language, code, title);
        for (PCMContainer pcmContainer : pcmContainers) {
            PCM pcm = pcmContainer.getPcm();
            pcm.normalize(this.pcmFactory);
            this.cellContentInterpreter.interpretCells(pcm);
        }
        return pcmContainers;
    }

    private List<PCMContainer> loadCsv(File fileContent, char separator, char quote, boolean productAsLines) throws IOException {
        CSVLoader loader = new CSVLoader(this.pcmFactory, separator, quote, productAsLines);
        List pcmContainers = loader.load(fileContent);
        return pcmContainers;
    }

    private List<PCMContainer> loadCsv(String fileContent, char separator, char quote, boolean productAsLines) throws IOException {
        CSVLoader loader = new CSVLoader(this.pcmFactory, separator, quote, productAsLines);
        List pcmContainers = loader.load(fileContent);
        return pcmContainers;
    }

    private List<PCMContainer> loadHtml(String fileContent, boolean productAsLines) throws IOException {
        HTMLLoader loader = new HTMLLoader(this.pcmFactory, productAsLines);
        List pcmContainers = loader.load(fileContent);
        return pcmContainers;
    }

    public Result get(String id) {
        DatabasePCM dbPCM = Database.INSTANCE.get(id);
        String json = Database.INSTANCE.serializeDatabasePCM(dbPCM);
        return PCMAPI.ok((String)json);
    }

    public Result save(String id) {
        JsValue json = Json.parse((String)PCMAPI.request().body().asJson().toString());
        String ipAddress = PCMAPI.request().remoteAddress();
        List<PCMContainer> pcmContainers = this.createContainers(json);
        if (pcmContainers.size() == 1) {
            DatabasePCM databasePCM = new DatabasePCM(id, pcmContainers.get(0));
            Database.INSTANCE.update(databasePCM);
            return PCMAPI.ok();
        }
        return PCMAPI.badRequest((String)"multiple pcms not supported");
    }

    public Result create() {
        JsValue json = Json.parse((String)PCMAPI.request().body().asJson().toString());
        List<PCMContainer> pcmContainers = this.createContainers(json);
        if (pcmContainers.size() == 1) {
            String id = Database.INSTANCE.create(pcmContainers.get(0));
            return PCMAPI.ok((String)id);
        }
        return PCMAPI.badRequest((String)"multiple pcms not supported");
    }

    public Result remove(String id) {
        Database.INSTANCE.remove(id);
        return PCMAPI.ok();
    }

    public Result convert(String id, String type, boolean productAsLines) {
        String data;
        DatabasePCM dbPCM = Database.INSTANCE.get(id);
        PCMContainer pcmContainer = dbPCM.getPCMContainer();
        pcmContainer.getMetadata().setProductAsLines(Boolean.valueOf(productAsLines));
        if (type.equals("csv")) {
            data = this.csvExporter.export(pcmContainer);
        } else if (type.equals("wikitext")) {
            data = this.wikiExporter.export(pcmContainer);
        } else {
            return PCMAPI.badRequest((String)"Type error. Return only 'csv' or 'wikitext' types.");
        }
        return PCMAPI.ok((String)data);
    }

    public Result importer(String type) {
        List<PCMContainer> pcmContainers;
        block20: {
            String fileContent;
            Object title;
            DynamicForm dynamicForm = Form.form().bindFromRequest(new String[0]);
            Boolean productAsLines = false;
            if (dynamicForm.get("productAsLines") != null) {
                productAsLines = true;
            }
            if (type.equals("wikipedia")) {
                String url = dynamicForm.get("url");
                try {
                    String title2;
                    URL pageURL = new URL(url);
                    String host = pageURL.getHost();
                    String language = host.substring(0, host.indexOf(46));
                    String file = URLDecoder.decode(pageURL.getFile(), StandardCharsets.UTF_8.name());
                    if (file.endsWith("/")) {
                        file = file.substring(0, file.length() - 1);
                    }
                    if ((pcmContainers = this.loadWikitext(language, title2 = file.substring(file.lastIndexOf(47) + 1))).isEmpty()) {
                        return PCMAPI.notFound((String)"No matrices were found in this Wikipedia page");
                    }
                    break block20;
                }
                catch (MalformedURLException e) {
                    return PCMAPI.notFound((String)"URL is not a valid Wikipedia page");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return PCMAPI.notFound((String)"The page has not been found.");
                }
            }
            if (type.equals("csv")) {
                title = dynamicForm.get("title");
                fileContent = "";
                try {
                    Http.MultipartFormData body = PCMAPI.request().body().asMultipartFormData();
                    Http.MultipartFormData.FilePart file = body.getFile("file");
                    fileContent = Files.toString((File)file.getFile(), (Charset)Charsets.UTF_8);
                }
                catch (Exception e) {
                    fileContent = dynamicForm.field("file").value();
                }
                char separator = dynamicForm.get("separator").charAt(0);
                char quote = '\"';
                String delimiter = dynamicForm.get("quote");
                if (delimiter.length() != 0) {
                    quote = delimiter.charAt(0);
                }
                try {
                    pcmContainers = this.loadCsv(fileContent, separator, quote, (boolean)productAsLines);
                    PCMContainer pcmContainer = pcmContainers.get(0);
                    pcmContainer.getPcm().setName((String)title);
                }
                catch (IOException e) {
                    return PCMAPI.badRequest((String)"This file is invalid.");
                }
            }
            if (type.equals("html")) {
                title = dynamicForm.get("title");
                fileContent = "";
                try {
                    Http.MultipartFormData body = PCMAPI.request().body().asMultipartFormData();
                    Http.MultipartFormData.FilePart file = body.getFile("file");
                    fileContent = Files.toString((File)file.getFile(), (Charset)Charsets.UTF_8);
                }
                catch (Exception e) {
                    fileContent = dynamicForm.field("file").value();
                }
                try {
                    pcmContainers = this.loadHtml(fileContent, productAsLines);
                    if (pcmContainers.isEmpty()) {
                        return PCMAPI.notFound((String)"No matrices were found in this html page");
                    }
                    break block20;
                }
                catch (IOException e) {
                    return PCMAPI.badRequest((String)"This file is invalid.");
                }
            }
            return PCMAPI.internalServerError((String)"File format not found or invalid.");
        }
        for (PCMContainer pcmContainer : pcmContainers) {
            pcmContainer.getPcm().normalize(this.pcmFactory);
        }
        String jsonResult = Database.INSTANCE.serializePCMContainersToJSON(pcmContainers);
        return PCMAPI.ok((String)jsonResult);
    }

    private List<PCMContainer> createContainers(JsValue jsonContent) {
        JsObject jsonObject = (JsObject)jsonContent;
        String jsonPCM = Json.stringify((JsValue)((JsValue)jsonObject.value().apply((Object)"pcm")));
        List containers = this.jsonLoader.load(jsonPCM);
        JsObject jsonMetadata = (JsObject)jsonObject.value().apply((Object)"metadata");
        for (PCMContainer container : containers) {
            this.saveMetadatas(container, jsonMetadata);
        }
        return containers;
    }

    private void saveMetadatas(PCMContainer container, JsObject jsonMetadata) {
        int position;
        Map jsonPos;
        PCMMetadata metadata = container.getMetadata();
        PCM pcm = metadata.getPcm();
        JsArray jsonProductPositions = (JsArray)jsonMetadata.value().apply((Object)"productPositions");
        JsArray jsonFeaturePositions = (JsArray)jsonMetadata.value().apply((Object)"featurePositions");
        for (JsValue jsonProductPosition : JavaConversions.seqAsJavaList((Seq)jsonProductPositions.value())) {
            jsonPos = ((JsObject)jsonProductPosition).value();
            String productName = ((JsString)jsonPos.apply((Object)"product")).value();
            position = Integer.parseInt(((JsValue)jsonPos.apply((Object)"position")).toString());
            Product product = null;
            for (Product p : pcm.getProducts()) {
                if (!p.getName().equals(productName)) continue;
                product = p;
                break;
            }
            metadata.setProductPosition(product, position);
        }
        for (JsValue jsonFeaturePosition : JavaConversions.seqAsJavaList((Seq)jsonFeaturePositions.value())) {
            jsonPos = ((JsObject)jsonFeaturePosition).value();
            String featureName = ((JsString)jsonPos.apply((Object)"feature")).value();
            position = Integer.parseInt(((JsValue)jsonPos.apply((Object)"position")).toString());
            Feature feature = null;
            for (Feature f2 : pcm.getConcreteFeatures()) {
                if (!f2.getName().equals(featureName)) continue;
                feature = f2;
                break;
            }
            metadata.setFeaturePosition(feature, position);
        }
    }

    public Result exporter(String type) {
        String code;
        DynamicForm dynamicForm = Form.form().bindFromRequest(new String[0]);
        String title = dynamicForm.get("title");
        Boolean productAsLines = false;
        if (dynamicForm.get("productAsLines").equals("true")) {
            productAsLines = true;
        }
        JsValue jsonContent = Json.parse((String)dynamicForm.field("file").value());
        PCMContainer container = this.createContainers(jsonContent).get(0);
        container.getMetadata().setProductAsLines(productAsLines);
        if (type.equals("wikitext")) {
            code = this.wikiExporter.export(container);
        } else if (type.equals("csv")) {
            char separator = dynamicForm.get("separator").charAt(0);
            char quote = '\u0000';
            String delimiter = dynamicForm.get("quote");
            if (delimiter.length() != 0) {
                quote = delimiter.charAt(0);
            }
            code = this.csvExporter.export(container, separator, quote);
        } else {
            return PCMAPI.internalServerError((String)"File format not found or invalid.");
        }
        return PCMAPI.ok((String)code);
    }

    public Result extractContent() {
        JsonNode json = PCMAPI.request().body().asJson();
        String type = json.get("type").asText();
        String rawContent = json.get("rawContent").asText();
        if (type != null && rawContent != null) {
            String content = "";
            if (!"wikipedia".equals(type)) {
                return PCMAPI.badRequest((String)"unknown type");
            }
            String language = "en";
            CellContentExtractor wikitextContentExtractor = new CellContentExtractor(language, this.miner.preprocessor(), this.wikitextTemplateProcessor, this.miner.parser());
            content = wikitextContentExtractor.extractCellContent(rawContent);
            return PCMAPI.ok((String)content);
        }
        return PCMAPI.badRequest();
    }

    public Result i18n() {
        return PCMAPI.ok((String)this.i18nService.getMessagesJson(PCMAPI.lang().code()).toString());
    }

    public Result setLang(String language) {
        if (this.i18nService.isDefined(language)) {
            PCMAPI.changeLang((String)language.toUpperCase());
            return PCMAPI.ok((String)"");
        }
        PCMAPI.clearLang();
        return PCMAPI.ok((String)"language unknown");
    }
}

