/*
 * Decompiled with CFR 0.152.
 */
package model;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.WriteResult;
import com.mongodb.util.JSON;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import model.DatabasePCM;
import model.PCMInfo;
import org.bson.types.ObjectId;
import org.opencompare.api.java.AbstractFeature;
import org.opencompare.api.java.Feature;
import org.opencompare.api.java.PCM;
import org.opencompare.api.java.PCMContainer;
import org.opencompare.api.java.PCMMetadata;
import org.opencompare.api.java.Product;
import org.opencompare.api.java.impl.io.KMFJSONExporter;
import org.opencompare.api.java.impl.io.KMFJSONLoader;

public class Database {
    public static Database INSTANCE = new Database();
    private KMFJSONLoader kmfLoader = new KMFJSONLoader();
    private KMFJSONExporter kmfSerializer = new KMFJSONExporter();
    private Base64.Decoder base64Decoder = Base64.getDecoder();
    private DB db;
    private DBCollection pcms;
    private String mongoVersion;

    private Database() {
        try {
            MongoClient mongoClient = new MongoClient("localhost", 27017);
            this.db = mongoClient.getDB("opencompare");
            this.mongoVersion = this.db.command("buildInfo").getString("version");
            this.pcms = this.db.getCollection("pcms");
            boolean indexInitialized = false;
            for (DBObject indexInfo : this.pcms.getIndexInfo()) {
                if (!indexInfo.get("name").equals("pcm.name_text")) continue;
                indexInitialized = true;
            }
            if (!indexInitialized) {
                this.pcms.createIndex((DBObject)new BasicDBObject("pcm.name", (Object)"text"));
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public List<PCMInfo> search(String request) {
        ArrayList<PCMInfo> results = new ArrayList<PCMInfo>();
        DBCursor cursor = this.pcms.find((DBObject)new BasicDBObject(), (DBObject)new BasicDBObject("pcm.name", (Object)"1"));
        for (DBObject result : cursor) {
            String id = result.get("_id").toString();
            DBObject pcm = (DBObject)result.get("pcm");
            String encodedName = pcm.get("name").toString();
            String name = new String(this.base64Decoder.decode(encodedName.getBytes()));
            if (!name.toLowerCase().contains(request.toLowerCase())) continue;
            results.add(new PCMInfo(id, name));
        }
        return results;
    }

    public long count() {
        return this.pcms.count();
    }

    public List<PCMInfo> list(int limit, int page) {
        int skipped = (page - 1) * limit;
        DBCursor cursor = this.pcms.find((DBObject)new BasicDBObject(), (DBObject)new BasicDBObject("pcm.name", (Object)"1")).sort((DBObject)new BasicDBObject("_id", (Object)1)).skip(skipped).limit(limit);
        ArrayList<PCMInfo> results = new ArrayList<PCMInfo>();
        for (DBObject result : cursor) {
            DBObject dbPCM = (DBObject)result.get("pcm");
            Object dbID = result.get("_id");
            if (dbID == null || dbPCM == null) continue;
            String id = dbID.toString();
            String name = dbPCM.get("name").toString();
            name = new String(this.base64Decoder.decode(name.getBytes()));
            PCMInfo info = new PCMInfo(id, name);
            results.add(info);
        }
        return results;
    }

    public DatabasePCM get(String id) {
        if (ObjectId.isValid((String)id)) {
            BasicDBObject searchById = new BasicDBObject("_id", (Object)new ObjectId(id));
            DBObject result = this.pcms.findOne((DBObject)searchById);
            DatabasePCM var = this.createDatabasePCMInstance(result);
            return var;
        }
        return new DatabasePCM(null, null);
    }

    public void update(DatabasePCM databasePCM) {
        DBObject dbPCMContainer = this.serializePCMContainer(databasePCM.getPCMContainer());
        this.pcms.update((DBObject)new BasicDBObject("_id", (Object)new ObjectId(databasePCM.getId())), dbPCMContainer);
    }

    public String create(PCMContainer pcmContainer) {
        DBObject newPCM = this.serializePCMContainer(pcmContainer);
        WriteResult result = this.pcms.insert(new DBObject[]{newPCM});
        String id = newPCM.get("_id").toString();
        return id;
    }

    private DatabasePCM createDatabasePCMInstance(DBObject object) {
        DatabasePCM var;
        if (object == null) {
            var = new DatabasePCM(null, null);
        } else {
            String id = object.get("_id").toString();
            String json = JSON.serialize((Object)object.get("pcm"));
            List pcmContainers = this.kmfLoader.load(json);
            if (pcmContainers.size() == 1) {
                PCMContainer pcmContainer = (PCMContainer)pcmContainers.get(0);
                PCMMetadata metadata = pcmContainer.getMetadata();
                DBObject dbMetadata = (DBObject)object.get("metadata");
                List dbProductPositions = (List)dbMetadata.get("productPositions");
                for (DBObject dbProductPosition : dbProductPositions) {
                    String productName = dbProductPosition.get("product").toString();
                    Product product = null;
                    for (Product p : pcmContainer.getPcm().getProducts()) {
                        if (!p.getName().equals(productName)) continue;
                        product = p;
                        break;
                    }
                    int position = Integer.parseInt(dbProductPosition.get("position").toString());
                    metadata.setProductPosition(product, position);
                }
                List dbFeaturePositions = (List)dbMetadata.get("featurePositions");
                for (DBObject dbFeaturePosition : dbFeaturePositions) {
                    String featureName = dbFeaturePosition.get("feature").toString();
                    Feature feature = null;
                    for (Feature f2 : pcmContainer.getPcm().getConcreteFeatures()) {
                        if (!f2.getName().equals(featureName)) continue;
                        feature = f2;
                        break;
                    }
                    int position = Integer.parseInt(dbFeaturePosition.get("position").toString());
                    metadata.setFeaturePosition(feature, position);
                }
                var = new DatabasePCM(id, pcmContainer);
            } else {
                var = new DatabasePCM(null, null);
            }
        }
        return var;
    }

    public boolean exists(String id) {
        if (ObjectId.isValid((String)id)) {
            BasicDBObject searchById = new BasicDBObject("_id", (Object)new ObjectId(id));
            DBObject result = this.pcms.findOne((DBObject)searchById);
            return result != null;
        }
        return false;
    }

    public void remove(String id) {
        this.pcms.remove((DBObject)new BasicDBObject("_id", (Object)new ObjectId(id)));
    }

    private DBObject serializePCMContainer(PCMContainer pcmContainer) {
        PCM pcm = pcmContainer.getPcm();
        PCMMetadata metadata = pcmContainer.getMetadata();
        String pcmInJSON = this.kmfSerializer.export(pcmContainer);
        DBObject dbPCM = (DBObject)JSON.parse((String)pcmInJSON);
        BasicDBObject dbMetadata = new BasicDBObject();
        ArrayList<BasicDBObject> dbProductPositions = new ArrayList<BasicDBObject>();
        for (Object product : pcm.getProducts()) {
            BasicDBObject dbProductPosition = new BasicDBObject();
            dbProductPosition.put("product", (Object)product.getName());
            dbProductPosition.put("position", (Object)metadata.getProductPosition((Product)product));
            dbProductPositions.add(dbProductPosition);
        }
        dbMetadata.put("productPositions", dbProductPositions);
        ArrayList<BasicDBObject> dbFeaturePositions = new ArrayList<BasicDBObject>();
        for (Feature feature : pcm.getConcreteFeatures()) {
            BasicDBObject dbFeaturePosition = new BasicDBObject();
            dbFeaturePosition.put("feature", (Object)feature.getName());
            dbFeaturePosition.put("position", (Object)metadata.getFeaturePosition((AbstractFeature)feature));
            dbFeaturePositions.add(dbFeaturePosition);
        }
        dbMetadata.put("featurePositions", dbFeaturePositions);
        BasicDBObject dbContainer = new BasicDBObject();
        dbContainer.put("pcm", (Object)dbPCM);
        dbContainer.put("metadata", (Object)dbMetadata);
        return dbContainer;
    }

    public String serializeDatabasePCM(DatabasePCM dbPCM) {
        DBObject dbContainer = this.serializePCMContainer(dbPCM.getPCMContainer());
        return JSON.serialize((Object)dbContainer);
    }

    public String serializePCMContainersToJSON(List<PCMContainer> pcmContainers) {
        ArrayList<DBObject> dbContainers = new ArrayList<DBObject>();
        for (PCMContainer pcmContainer : pcmContainers) {
            DBObject dbContainer = this.serializePCMContainer(pcmContainer);
            dbContainers.add(dbContainer);
        }
        return JSON.serialize(dbContainers);
    }
}

