/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.hac;

import org.opencompare.hac.ClusteringBuilder;
import org.opencompare.hac.agglomeration.AgglomerationMethod;
import org.opencompare.hac.experiment.DissimilarityMeasure;
import org.opencompare.hac.experiment.Experiment;

public final class HierarchicalAgglomerativeClusterer {
    private Experiment experiment;
    private DissimilarityMeasure dissimilarityMeasure;
    private AgglomerationMethod agglomerationMethod;

    public HierarchicalAgglomerativeClusterer(Experiment experiment, DissimilarityMeasure dissimilarityMeasure, AgglomerationMethod agglomerationMethod) {
        this.experiment = experiment;
        this.dissimilarityMeasure = dissimilarityMeasure;
        this.agglomerationMethod = agglomerationMethod;
    }

    public void setExperiment(Experiment experiment) {
        this.experiment = experiment;
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public void setDissimilarityMeasure(DissimilarityMeasure dissimilarityMeasure) {
        this.dissimilarityMeasure = dissimilarityMeasure;
    }

    public DissimilarityMeasure getDissimilarityMeasure() {
        return this.dissimilarityMeasure;
    }

    public void setAgglomerationMethod(AgglomerationMethod agglomerationMethod) {
        this.agglomerationMethod = agglomerationMethod;
    }

    public AgglomerationMethod getAgglomerationMethod() {
        return this.agglomerationMethod;
    }

    public void cluster(ClusteringBuilder clusteringBuilder) {
        double[][] dissimilarityMatrix = this.computeDissimilarityMatrix();
        int nObservations = dissimilarityMatrix.length;
        boolean[] indexUsed = new boolean[nObservations];
        int[] clusterCardinalities = new int[nObservations];
        for (int i = 0; i < nObservations; ++i) {
            indexUsed[i] = true;
            clusterCardinalities[i] = 1;
        }
        for (int a = 1; a < nObservations; ++a) {
            int k;
            Pair pair = HierarchicalAgglomerativeClusterer.findMostSimilarClusters(dissimilarityMatrix, indexUsed);
            int i = pair.getSmaller();
            int j = pair.getLarger();
            double d = dissimilarityMatrix[i][j];
            for (k = 0; k < nObservations; ++k) {
                double dissimilarity;
                if (k == i || k == j || !indexUsed[k]) continue;
                dissimilarityMatrix[i][k] = dissimilarity = this.agglomerationMethod.computeDissimilarity(dissimilarityMatrix[i][k], dissimilarityMatrix[j][k], dissimilarityMatrix[i][j], clusterCardinalities[i], clusterCardinalities[j], clusterCardinalities[k]);
                dissimilarityMatrix[k][i] = dissimilarity;
            }
            clusterCardinalities[i] = clusterCardinalities[i] + clusterCardinalities[j];
            indexUsed[j] = false;
            for (k = 0; k < nObservations; ++k) {
                dissimilarityMatrix[j][k] = Double.POSITIVE_INFINITY;
                dissimilarityMatrix[k][j] = Double.POSITIVE_INFINITY;
            }
            clusteringBuilder.merge(i, j, d);
        }
    }

    private double[][] computeDissimilarityMatrix() {
        double[][] dissimilarityMatrix = new double[this.experiment.getNumberOfObservations()][this.experiment.getNumberOfObservations()];
        for (int o = 0; o < dissimilarityMatrix.length; ++o) {
            dissimilarityMatrix[o][o] = 0.0;
        }
        for (int o1 = 0; o1 < dissimilarityMatrix.length; ++o1) {
            for (int o2 = 0; o2 < o1; ++o2) {
                double dissimilarity;
                dissimilarityMatrix[o1][o2] = dissimilarity = this.dissimilarityMeasure.computeDissimilarity(this.experiment, o1, o2);
                dissimilarityMatrix[o2][o1] = dissimilarity;
            }
        }
        return dissimilarityMatrix;
    }

    private static Pair findMostSimilarClusters(double[][] dissimilarityMatrix, boolean[] indexUsed) {
        Pair mostSimilarPair = new Pair();
        double smallestDissimilarity = Double.POSITIVE_INFINITY;
        for (int cluster = 0; cluster < dissimilarityMatrix.length; ++cluster) {
            if (!indexUsed[cluster]) continue;
            for (int neighbor = 0; neighbor < dissimilarityMatrix.length; ++neighbor) {
                if (!indexUsed[neighbor] || !(dissimilarityMatrix[cluster][neighbor] < smallestDissimilarity) || cluster == neighbor) continue;
                smallestDissimilarity = dissimilarityMatrix[cluster][neighbor];
                mostSimilarPair.set(cluster, neighbor);
            }
        }
        return mostSimilarPair;
    }

    private static final class Pair {
        private int cluster1;
        private int cluster2;

        private Pair() {
        }

        public final void set(int cluster1, int cluster2) {
            this.cluster1 = cluster1;
            this.cluster2 = cluster2;
        }

        public final int getLarger() {
            return Math.max(this.cluster1, this.cluster2);
        }

        public final int getSmaller() {
            return Math.min(this.cluster1, this.cluster2);
        }
    }
}

