/*
 * Decompiled with CFR 0.152.
 */
package play.data.format;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.format.Formatter;
import org.springframework.format.support.FormattingConversionService;
import play.data.format.Formats;
import play.libs.F;

public class Formatters {
    public static final FormattingConversionService conversion = new FormattingConversionService();

    public static <T> T parse(String string, Class<T> clazz) {
        return (T)conversion.convert((Object)string, clazz);
    }

    public static <T> T parse(Field field, String string, Class<T> clazz) {
        return (T)conversion.convert((Object)string, new TypeDescriptor(field), TypeDescriptor.valueOf(clazz));
    }

    public static <T> String print(T t) {
        if (t == null) {
            return "";
        }
        if (conversion.canConvert(t.getClass(), String.class)) {
            return (String)conversion.convert(t, String.class);
        }
        return t.toString();
    }

    public static <T> String print(Field field, T t) {
        return Formatters.print(new TypeDescriptor(field), t);
    }

    public static <T> String print(TypeDescriptor typeDescriptor, T t) {
        if (t == null) {
            return "";
        }
        if (typeDescriptor != null && conversion.canConvert(typeDescriptor, TypeDescriptor.valueOf(String.class))) {
            return (String)conversion.convert(t, typeDescriptor, TypeDescriptor.valueOf(String.class));
        }
        if (conversion.canConvert(t.getClass(), String.class)) {
            return (String)conversion.convert(t, String.class);
        }
        return t.toString();
    }

    private static <T> void registerOption() {
        conversion.addConverter(new GenericConverter(){

            public Object convert(Object object, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
                if (typeDescriptor.getObjectType().equals(String.class)) {
                    Object object2 = conversion.convert(object, typeDescriptor, typeDescriptor2.getElementTypeDescriptor());
                    if (object2 == null) {
                        return new F.None();
                    }
                    return new F.Some(object2);
                }
                if (typeDescriptor2.getObjectType().equals(String.class)) {
                    if (object == null) {
                        return "";
                    }
                    F.Option option = (F.Option)object;
                    if (!option.isDefined()) {
                        return "";
                    }
                    return conversion.convert(object, typeDescriptor.getElementTypeDescriptor(), typeDescriptor2);
                }
                return null;
            }

            public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
                HashSet<GenericConverter.ConvertiblePair> hashSet = new HashSet<GenericConverter.ConvertiblePair>();
                hashSet.add(new GenericConverter.ConvertiblePair(F.Option.class, String.class));
                hashSet.add(new GenericConverter.ConvertiblePair(String.class, F.Option.class));
                return hashSet;
            }
        });
    }

    public static <T> void register(Class<T> clazz, final SimpleFormatter<T> simpleFormatter) {
        conversion.addFormatterForFieldType(clazz, new Formatter<T>(){

            public T parse(String string, Locale locale) throws ParseException {
                return simpleFormatter.parse(string, locale);
            }

            public String print(T t, Locale locale) {
                return simpleFormatter.print(t, locale);
            }

            public String toString() {
                return simpleFormatter.toString();
            }
        });
    }

    public static <A extends Annotation, T> void register(final Class<T> clazz, final AnnotationFormatter<A, T> annotationFormatter) {
        final Class clazz2 = GenericTypeResolver.resolveTypeArguments(annotationFormatter.getClass(), AnnotationFormatter.class)[0];
        conversion.addConverter((GenericConverter)new ConditionalGenericConverter(){

            public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
                HashSet<GenericConverter.ConvertiblePair> hashSet = new HashSet<GenericConverter.ConvertiblePair>();
                hashSet.add(new GenericConverter.ConvertiblePair(clazz, String.class));
                return hashSet;
            }

            public boolean matches(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
                return typeDescriptor.getAnnotation(clazz2) != null;
            }

            public Object convert(Object object, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
                Annotation annotation = typeDescriptor.getAnnotation(clazz2);
                Locale locale = LocaleContextHolder.getLocale();
                try {
                    return annotationFormatter.print(annotation, object, locale);
                }
                catch (Exception exception) {
                    throw new ConversionFailedException(typeDescriptor, typeDescriptor2, object, (Throwable)exception);
                }
            }

            public String toString() {
                return "@" + clazz2.getName() + " " + clazz.getName() + " -> " + String.class.getName() + ": " + annotationFormatter;
            }
        });
        conversion.addConverter((GenericConverter)new ConditionalGenericConverter(){

            public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
                HashSet<GenericConverter.ConvertiblePair> hashSet = new HashSet<GenericConverter.ConvertiblePair>();
                hashSet.add(new GenericConverter.ConvertiblePair(String.class, clazz));
                return hashSet;
            }

            public boolean matches(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
                return typeDescriptor2.getAnnotation(clazz2) != null;
            }

            public Object convert(Object object, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
                Annotation annotation = typeDescriptor2.getAnnotation(clazz2);
                Locale locale = LocaleContextHolder.getLocale();
                try {
                    return annotationFormatter.parse(annotation, (String)object, locale);
                }
                catch (Exception exception) {
                    throw new ConversionFailedException(typeDescriptor, typeDescriptor2, object, (Throwable)exception);
                }
            }

            public String toString() {
                return String.class.getName() + " -> @" + clazz2.getName() + " " + clazz.getName() + ": " + annotationFormatter;
            }
        });
    }

    static {
        Formatters.register(Date.class, new Formats.DateFormatter("yyyy-MM-dd"));
        Formatters.register(Date.class, new Formats.AnnotationDateFormatter());
        Formatters.register(String.class, new Formats.AnnotationNonEmptyFormatter());
        Formatters.registerOption();
    }

    public static abstract class AnnotationFormatter<A extends Annotation, T> {
        public abstract T parse(A var1, String var2, Locale var3) throws ParseException;

        public abstract String print(A var1, T var2, Locale var3);
    }

    public static abstract class SimpleFormatter<T> {
        public abstract T parse(String var1, Locale var2) throws ParseException;

        public abstract String print(T var1, Locale var2);
    }
}

