/*
 * Decompiled with CFR 0.152.
 */
package play.libs;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.mvc.Codec;
import play.core.j.JavaResults;
import play.libs.F;
import play.libs.Json;
import play.mvc.Results;

public abstract class Comet
extends Results.Chunks<String> {
    private Results.Chunks.Out<String> out;
    private String callbackMethod;

    public Comet(String string) {
        super(JavaResults.writeString((String)"text/html", (Codec)Codec.javaSupported((String)"utf-8")));
        this.callbackMethod = string;
    }

    public void onReady(Results.Chunks.Out<String> out) {
        this.out = out;
        out.write((Object)this.initialBuffer());
        this.onConnected();
    }

    protected String initialBuffer() {
        char[] cArray = new char[5120];
        Arrays.fill(cArray, ' ');
        return new String(cArray);
    }

    public void sendMessage(String string) {
        this.out.write((Object)("<script type=\"text/javascript\">" + this.callbackMethod + "('" + StringEscapeUtils.escapeEcmaScript((String)string) + "');</script>"));
    }

    public void sendMessage(JsonNode jsonNode) {
        this.out.write((Object)("<script type=\"text/javascript\">" + this.callbackMethod + "(" + Json.stringify((JsonNode)jsonNode) + ");</script>"));
    }

    public abstract void onConnected();

    public void onDisconnected(F.Callback0 callback0) {
        this.out.onDisconnected(callback0);
    }

    public void close() {
        this.out.close();
    }

    public static Comet whenConnected(String string, F.Callback<Comet> callback) {
        return new WhenConnectedComet(string, callback);
    }

    static final class WhenConnectedComet
    extends Comet {
        private static final Logger logger = LoggerFactory.getLogger(Comet.class);
        private final F.Callback<Comet> callback;

        WhenConnectedComet(String string, F.Callback<Comet> callback) {
            super(string);
            if (callback == null) {
                throw new NullPointerException("Comet onConnected callback cannot be null");
            }
            this.callback = callback;
        }

        @Override
        public void onConnected() {
            try {
                this.callback.invoke((Object)this);
            }
            catch (Throwable throwable) {
                logger.error("Exception in Comet.onConnected", throwable);
            }
        }
    }
}

