/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.io.wikipedia.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opencompare.io.wikipedia.parser.NestedTableChecker;
import org.opencompare.io.wikipedia.parser.WtToStringConverter;
import org.sweble.wikitext.engine.config.WikiConfig;
import org.sweble.wikitext.parser.nodes.WtNode;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0001\u0002\u0001\u001b\t9\"+Y<DK2d7i\u001c8uK:$X\t\u001f;sC\u000e$xN\u001d\u0006\u0003\u0007\u0011\ta\u0001]1sg\u0016\u0014(BA\u0003\u0007\u0003%9\u0018n[5qK\u0012L\u0017M\u0003\u0002\b\u0011\u0005\u0011\u0011n\u001c\u0006\u0003\u0013)\t1b\u001c9f]\u000e|W\u000e]1sK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001aD\u0001\"\u0006\u0001\u0003\u0006\u0004%\tAF\u0001\u000bo&\\\u0017nQ8oM&<W#A\f\u0011\u0005a\tS\"A\r\u000b\u0005iY\u0012AB2p]\u001aLwM\u0003\u0002\u001d;\u00051QM\\4j]\u0016T!AH\u0010\u0002\u0011]L7.\u001b;fqRT!\u0001\t\u0006\u0002\rM<XM\u00197f\u0013\t\u0011\u0013D\u0001\u0006XS.L7i\u001c8gS\u001eD\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006IaF\u0001\fo&\\\u0017nQ8oM&<\u0007\u0005C\u0003'\u0001\u0011\u0005q%\u0001\u0004=S:LGO\u0010\u000b\u0003Q)\u0002\"!\u000b\u0001\u000e\u0003\tAQ!F\u0013A\u0002]Aq\u0001\f\u0001C\u0002\u0013%Q&A\u0006ue&l\u0007+\u0019;uKJtW#\u0001\u0018\u0011\u0005=2T\"\u0001\u0019\u000b\u0005E\u0012\u0014!\u0002:fO\u0016D(BA\u001a5\u0003\u0011)H/\u001b7\u000b\u0003U\nAA[1wC&\u0011q\u0007\r\u0002\b!\u0006$H/\u001a:o\u0011\u0019I\u0004\u0001)A\u0005]\u0005aAO]5n!\u0006$H/\u001a:oA!91\b\u0001b\u0001\n\u0013a\u0014A\u00058fgR,G\rV1cY\u0016\u001c\u0005.Z2lKJ,\u0012!\u0010\t\u0003SyJ!a\u0010\u0002\u0003%9+7\u000f^3e)\u0006\u0014G.Z\"iK\u000e\\WM\u001d\u0005\u0007\u0003\u0002\u0001\u000b\u0011B\u001f\u0002'9,7\u000f^3e)\u0006\u0014G.Z\"iK\u000e\\WM\u001d\u0011\t\u000f\r\u0003!\u0019!C\u0005\t\u0006\u0019r\u000f\u001e+p'R\u0014\u0018N\\4D_:4XM\u001d;feV\tQ\t\u0005\u0002*\r&\u0011qI\u0001\u0002\u0014/R$vn\u0015;sS:<7i\u001c8wKJ$XM\u001d\u0005\u0007\u0013\u0002\u0001\u000b\u0011B#\u0002)]$Hk\\*ue&twmQ8om\u0016\u0014H/\u001a:!\u0011\u0015Y\u0005\u0001\"\u0001M\u0003\u001d)\u0007\u0010\u001e:bGR$\"!\u0014+\u0011\u00059\u000bfBA\bP\u0013\t\u0001\u0006#\u0001\u0004Qe\u0016$WMZ\u0005\u0003%N\u0013aa\u0015;sS:<'B\u0001)\u0011\u0011\u0015)&\n1\u0001W\u0003\u0011\u0019W\r\u001c7\u0011\u0005][V\"\u0001-\u000b\u0005eS\u0016!\u00028pI\u0016\u001c(BA\u0002\u001e\u0013\ta\u0006L\u0001\u0004Xi:{G-\u001a\u0005\u0006=\u0002!\taX\u0001\u0005iJLW\u000e\u0006\u0002NA\")\u0011-\u0018a\u0001\u001b\u0006\t1\u000f")
public class RawCellContentExtractor {
    private final WikiConfig wikiConfig;
    private final Pattern trimPattern;
    private final NestedTableChecker nestedTableChecker;
    private final WtToStringConverter wtToStringConverter;

    public WikiConfig wikiConfig() {
        return this.wikiConfig;
    }

    private Pattern trimPattern() {
        return this.trimPattern;
    }

    private NestedTableChecker nestedTableChecker() {
        return this.nestedTableChecker;
    }

    private WtToStringConverter wtToStringConverter() {
        return this.wtToStringConverter;
    }

    public String extract(WtNode cell) {
        String string;
        if (this.nestedTableChecker().hasNestedTable(cell)) {
            string = "";
        } else {
            String string2;
            try {
                string2 = this.wtToStringConverter().convert(cell);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string2 = "";
            }
            String code = string2;
            string = this.trim(code);
        }
        return string;
    }

    public String trim(String s) {
        Matcher matcher = this.trimPattern().matcher(s);
        return matcher.matches() && matcher.groupCount() == 1 ? matcher.group(1) : "";
    }

    public RawCellContentExtractor(WikiConfig wikiConfig) {
        this.wikiConfig = wikiConfig;
        this.trimPattern = Pattern.compile("[\\s|!]*([\\s\\S]*?)\\s*");
        this.nestedTableChecker = new NestedTableChecker();
        this.wtToStringConverter = new WtToStringConverter(wikiConfig);
    }
}

