/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.formalizer.clustering;

import org.opencompare.formalizer.clustering.ClusteringDissimilarityMeasure;
import org.opencompare.formalizer.clustering.ClusteringExperiment;
import org.opencompare.formalizer.clustering.HierarchicalClusterer$;
import org.opencompare.hac.ClusteringBuilder;
import org.opencompare.hac.HierarchicalAgglomerativeClusterer;
import org.opencompare.hac.agglomeration.AgglomerationMethod;
import org.opencompare.hac.dendrogram.Dendrogram;
import org.opencompare.hac.dendrogram.DendrogramBuilder;
import org.opencompare.hac.dendrogram.DendrogramNode;
import org.opencompare.hac.dendrogram.MergeNode;
import org.opencompare.hac.dendrogram.ObservationNode;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001B\u0001\u0003\u0001-\u0011Q\u0003S5fe\u0006\u00148\r[5dC2\u001cE.^:uKJ,'O\u0003\u0002\u0004\t\u0005Q1\r\\;ti\u0016\u0014\u0018N\\4\u000b\u0005\u00151\u0011A\u00034pe6\fG.\u001b>fe*\u0011q\u0001C\u0001\f_B,gnY8na\u0006\u0014XMC\u0001\n\u0003\ry'oZ\u0002\u0001+\ta1d\u0005\u0002\u0001\u001bA\u0011a\"E\u0007\u0002\u001f)\t\u0001#A\u0003tG\u0006d\u0017-\u0003\u0002\u0013\u001f\t1\u0011I\\=SK\u001aD\u0001\u0002\u0006\u0001\u0003\u0006\u0004%\t!F\u0001\u0014I&\u001c8/[7jY\u0006\u0014\u0018\u000e^=NKR\u0014\u0018nY\u000b\u0002-A)abF\r\u001aI%\u0011\u0001d\u0004\u0002\n\rVt7\r^5p]J\u0002\"AG\u000e\r\u0001\u0011)A\u0004\u0001b\u0001;\t\tA+\u0005\u0002\u001fCA\u0011abH\u0005\u0003A=\u0011qAT8uQ&tw\r\u0005\u0002\u000fE%\u00111e\u0004\u0002\u0004\u0003:L\bC\u0001\b&\u0013\t1sB\u0001\u0004E_V\u0014G.\u001a\u0005\tQ\u0001\u0011\t\u0011)A\u0005-\u0005!B-[:tS6LG.\u0019:jiflU\r\u001e:jG\u0002B\u0001B\u000b\u0001\u0003\u0006\u0004%\taK\u0001\ni\"\u0014Xm\u001d5pY\u0012,\u0012\u0001\f\t\u0004\u001d5\"\u0013B\u0001\u0018\u0010\u0005\u0019y\u0005\u000f^5p]\"A\u0001\u0007\u0001B\u0001B\u0003%A&\u0001\u0006uQJ,7\u000f[8mI\u0002B\u0001B\r\u0001\u0003\u0006\u0004%\taM\u0001\u000f[\u0006D8\t\\;ti\u0016\u00148+\u001b>f+\u0005!\u0004c\u0001\b.kA\u0011aBN\u0005\u0003o=\u00111!\u00138u\u0011!I\u0004A!A!\u0002\u0013!\u0014aD7bq\u000ecWo\u001d;feNK'0\u001a\u0011\t\u0011m\u0002!Q1A\u0005\u0002q\n\u0001#\\3sO&twmQ8oI&$\u0018n\u001c8\u0016\u0003u\u00022AD\u0017?!\u0015qqcP L!\r\u0001\u0005*\u0007\b\u0003\u0003\u001as!AQ#\u000e\u0003\rS!\u0001\u0012\u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0012BA$\u0010\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0013&\u0003\t1K7\u000f\u001e\u0006\u0003\u000f>\u0001\"A\u0004'\n\u00055{!a\u0002\"p_2,\u0017M\u001c\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005{\u0005\tR.\u001a:hS:<7i\u001c8eSRLwN\u001c\u0011\t\u0011E\u0003!Q1A\u0005\u0002I\u000b1#Y4hY>lWM]1uS>tW*\u001a;i_\u0012,\u0012a\u0015\t\u0003)fk\u0011!\u0016\u0006\u0003-^\u000bQ\"Y4hY>lWM]1uS>t'B\u0001-\u0007\u0003\rA\u0017mY\u0005\u00035V\u00131#Q4hY>lWM]1uS>tW*\u001a;i_\u0012D\u0001\u0002\u0018\u0001\u0003\u0002\u0003\u0006IaU\u0001\u0015C\u001e<Gn\\7fe\u0006$\u0018n\u001c8NKRDw\u000e\u001a\u0011\t\u000by\u0003A\u0011A0\u0002\rqJg.\u001b;?)\u0019\u0001'm\u00193fMB\u0019\u0011\rA\r\u000e\u0003\tAQ\u0001F/A\u0002YAQAK/A\u00021BQAM/A\u0002QBQaO/A\u0002uBq!U/\u0011\u0002\u0003\u00071\u000bC\u0003i\u0001\u0011\u0005\u0011.A\u0004dYV\u001cH/\u001a:\u0015\u0005)\\\u0007c\u0001!I\u007f!)An\u001aa\u0001\u007f\u00051a/\u00197vKNDQA\u001c\u0001\u0005\n=\fq\"\u001a=ue\u0006\u001cGo\u00117vgR,'o\u001d\u000b\u0004UB,\b\"B9n\u0001\u0004\u0011\u0018AC3ya\u0016\u0014\u0018.\\3oiB\u0019\u0011m]\r\n\u0005Q\u0014!\u0001F\"mkN$XM]5oO\u0016C\b/\u001a:j[\u0016tG\u000fC\u0003w[\u0002\u0007q/\u0001\u0006eK:$'o\\4sC6\u0004\"\u0001\u001f>\u000e\u0003eT!A^,\n\u0005mL(A\u0003#f]\u0012\u0014xn\u001a:b[\u001e9QPAA\u0001\u0012\u0003q\u0018!\u0006%jKJ\f'o\u00195jG\u0006d7\t\\;ti\u0016\u0014XM\u001d\t\u0003C~4\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011\u0011A\n\u0003\u007f6AaAX@\u0005\u0002\u0005\u0015A#\u0001@\t\u0013\u0005%q0%A\u0005\u0002\u0005-\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'\u0006\u0003\u0002\u000e\u0005\rRCAA\bU\r\u0019\u0016\u0011C\u0016\u0003\u0003'\u0001B!!\u0006\u0002 5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"A\u0005v]\u000eDWmY6fI*\u0019\u0011QD\b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\"\u0005]!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00121A$a\u0002C\u0002u\u0001")
public class HierarchicalClusterer<T> {
    private final Function2<T, T, Object> dissimilarityMetric;
    private final Option<Object> threshold;
    private final Option<Object> maxClusterSize;
    private final Option<Function2<List<T>, List<T>, Object>> mergingCondition;
    private final AgglomerationMethod agglomerationMethod;

    public static <T> AgglomerationMethod $lessinit$greater$default$5() {
        return HierarchicalClusterer$.MODULE$.$lessinit$greater$default$5();
    }

    public Function2<T, T, Object> dissimilarityMetric() {
        return this.dissimilarityMetric;
    }

    public Option<Object> threshold() {
        return this.threshold;
    }

    public Option<Object> maxClusterSize() {
        return this.maxClusterSize;
    }

    public Option<Function2<List<T>, List<T>, Object>> mergingCondition() {
        return this.mergingCondition;
    }

    public AgglomerationMethod agglomerationMethod() {
        return this.agglomerationMethod;
    }

    public List<List<T>> cluster(List<T> values) {
        ClusteringExperiment experiment = new ClusteringExperiment(values.toIndexedSeq());
        ClusteringDissimilarityMeasure<T> dissimilarityMeasure = new ClusteringDissimilarityMeasure<T>(this.dissimilarityMetric());
        DendrogramBuilder dendrogramBuilder = new DendrogramBuilder(experiment.getNumberOfObservations());
        HierarchicalAgglomerativeClusterer clusterer = new HierarchicalAgglomerativeClusterer(experiment, dissimilarityMeasure, this.agglomerationMethod());
        clusterer.cluster((ClusteringBuilder)dendrogramBuilder);
        return this.extractClusters(experiment, dendrogramBuilder.getDendrogram());
    }

    private List<List<T>> extractClusters(ClusteringExperiment<T> experiment, Dendrogram dendrogram) {
        return Option$.MODULE$.apply((Object)dendrogram.getRoot()).isDefined() ? this.extractClustersRecursion$1(dendrogram.getRoot(), experiment) : Nil$.MODULE$;
    }

    private final List extractClustersRecursion$1(DendrogramNode node, ClusteringExperiment experiment$1) {
        DendrogramNode dendrogramNode;
        block7: {
            List list;
            block6: {
                block5: {
                    List list2;
                    dendrogramNode = node;
                    if (!(dendrogramNode instanceof MergeNode)) break block5;
                    MergeNode mergeNode = (MergeNode)dendrogramNode;
                    List left = this.extractClustersRecursion$1(mergeNode.getLeft(), experiment$1);
                    List right = this.extractClustersRecursion$1(mergeNode.getRight(), experiment$1);
                    if (!(left.size() != 1 || right.size() != 1 || this.threshold().isDefined() && !(mergeNode.getDissimilarity() < BoxesRunTime.unboxToDouble((Object)this.threshold().get())) || this.maxClusterSize().isDefined() && ((SeqLike)left.head()).size() + ((SeqLike)right.head()).size() > BoxesRunTime.unboxToInt((Object)this.maxClusterSize().get()) || this.mergingCondition().isDefined() && !BoxesRunTime.unboxToBoolean((Object)((Function2)this.mergingCondition().get()).apply(left.head(), right.head())))) {
                        List[] listArray = new List[1];
                        List list3 = left;
                        listArray[0] = (List)right.$colon$colon$colon(list3).flatten((Function1)Predef$.MODULE$.$conforms());
                        list2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])listArray));
                    } else {
                        List list4 = left;
                        list2 = right.$colon$colon$colon(list4);
                    }
                    list = list2;
                    break block6;
                }
                if (!(dendrogramNode instanceof ObservationNode)) break block7;
                ObservationNode observationNode = (ObservationNode)dendrogramNode;
                List[] listArray = new List[1];
                Object t = experiment$1.getObservation(observationNode.getObservation());
                listArray[0] = Nil$.MODULE$.$colon$colon(t);
                list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])listArray));
            }
            return list;
        }
        throw new MatchError((Object)dendrogramNode);
    }

    public HierarchicalClusterer(Function2<T, T, Object> dissimilarityMetric, Option<Object> threshold, Option<Object> maxClusterSize, Option<Function2<List<T>, List<T>, Object>> mergingCondition, AgglomerationMethod agglomerationMethod) {
        this.dissimilarityMetric = dissimilarityMetric;
        this.threshold = threshold;
        this.maxClusterSize = maxClusterSize;
        this.mergingCondition = mergingCondition;
        this.agglomerationMethod = agglomerationMethod;
    }
}

