/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.api.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opencompare.api.java.AbstractFeature;
import org.opencompare.api.java.Feature;
import org.opencompare.api.java.FeatureGroup;
import org.opencompare.api.java.PCM;
import org.opencompare.api.java.Product;

public class PCMMetadata {
    protected PCM pcm;
    protected Boolean productAsLines;
    protected Map<Product, Integer> productPositions;
    protected Map<AbstractFeature, Integer> featurePositions;

    public PCMMetadata(PCM pcm) {
        this.pcm = pcm;
        this.setProductAsLines(true);
        this.productPositions = new HashMap<Product, Integer>();
        this.featurePositions = new HashMap<AbstractFeature, Integer>();
    }

    public Integer getLastProductIndex() {
        return Collections.max(this.productPositions.values());
    }

    public Integer getLastFeatureIndex() {
        return Collections.max(this.featurePositions.values());
    }

    public int getProductPosition(Product product) {
        return this.productPositions.getOrDefault(product, 0);
    }

    public void setProductPosition(Product product, int position) {
        this.productPositions.put(product, position);
    }

    public int getFeaturePosition(AbstractFeature feature) {
        FeatureGroup featureGroup;
        List<Feature> features;
        AbstractFeature result = feature;
        if (!this.featurePositions.containsKey(feature) && feature instanceof FeatureGroup && !(features = (featureGroup = (FeatureGroup)feature).getConcreteFeatures()).isEmpty()) {
            Collections.sort(features, new Comparator<Feature>(){

                @Override
                public int compare(Feature feat1, Feature feat2) {
                    return PCMMetadata.this.getFeaturePosition(feat1) - PCMMetadata.this.getFeaturePosition(feat2);
                }
            });
            result = features.get(0);
        }
        return this.featurePositions.getOrDefault(result, 0);
    }

    public void setFeaturePosition(AbstractFeature feature, int position) {
        this.featurePositions.put(feature, position);
    }

    public List<Product> getSortedProducts() {
        ArrayList<Product> result = new ArrayList<Product>(this.pcm.getProducts());
        Collections.sort(result, new Comparator<Product>(){

            @Override
            public int compare(Product o1, Product o2) {
                Integer op1 = PCMMetadata.this.getProductPosition(o1);
                Integer op2 = PCMMetadata.this.getProductPosition(o2);
                return op1.compareTo(op2);
            }
        });
        return result;
    }

    public List<Feature> getSortedFeatures() {
        ArrayList<Feature> result = new ArrayList<Feature>(this.pcm.getConcreteFeatures());
        Collections.sort(result, new Comparator<Feature>(){

            @Override
            public int compare(Feature f1, Feature f2) {
                Integer fp1 = PCMMetadata.this.getFeaturePosition(f1);
                Integer fp2 = PCMMetadata.this.getFeaturePosition(f2);
                return fp1.compareTo(fp2);
            }
        });
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PCMMetadata) {
            PCMMetadata metadata = (PCMMetadata)obj;
            if (metadata.pcm == null || this.pcm == null) {
                return false;
            }
            if (metadata.pcm.equals(this.pcm)) {
                for (Product product : this.pcm.getProducts()) {
                    if (this.getProductPosition(product) == metadata.getProductPosition(product)) continue;
                    return false;
                }
                for (Feature feature : this.pcm.getConcreteFeatures()) {
                    if (this.getFeaturePosition(feature) == metadata.getFeaturePosition(feature)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public String toString() {
        String result = "PCMMetadata(";
        result = result + this.productPositions.toString() + ", ";
        result = result + this.featurePositions.toString() + ")";
        return result;
    }

    public PCM getPcm() {
        return this.pcm;
    }

    public Boolean getProductAsLines() {
        return this.productAsLines;
    }

    public void setProductAsLines(Boolean productAsLines) {
        this.productAsLines = productAsLines;
    }
}

