/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.api.java.io;

import com.opencsv.CSVWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.opencompare.api.java.AbstractFeature;
import org.opencompare.api.java.Cell;
import org.opencompare.api.java.Feature;
import org.opencompare.api.java.FeatureGroup;
import org.opencompare.api.java.PCM;
import org.opencompare.api.java.PCMContainer;
import org.opencompare.api.java.PCMMetadata;
import org.opencompare.api.java.Product;
import org.opencompare.api.java.io.IOMatrix;
import org.opencompare.api.java.io.PCMExporter;
import org.opencompare.api.java.util.PCMVisitor;
import org.opencompare.api.java.value.BooleanValue;
import org.opencompare.api.java.value.Conditional;
import org.opencompare.api.java.value.DateValue;
import org.opencompare.api.java.value.Dimension;
import org.opencompare.api.java.value.IntegerValue;
import org.opencompare.api.java.value.Multiple;
import org.opencompare.api.java.value.NotApplicable;
import org.opencompare.api.java.value.NotAvailable;
import org.opencompare.api.java.value.Partial;
import org.opencompare.api.java.value.RealValue;
import org.opencompare.api.java.value.StringValue;
import org.opencompare.api.java.value.Unit;
import org.opencompare.api.java.value.Version;

public class CSVExporter
implements PCMExporter,
PCMVisitor {
    private PCMMetadata metadata = null;
    private StringWriter stringWriter;
    private CSVWriter csvWriter;
    private List<String> headerLine;
    private List<String> productLine;
    private char separator = (char)44;
    private char quote = (char)34;
    private List<String[]> lines;
    private LinkedList<AbstractFeature> nextFeaturesToVisit;
    private int featureDepth;

    @Override
    public String export(PCMContainer container) {
        this.metadata = container.getMetadata();
        return this.export(container.getPcm());
    }

    private String export(PCM pcm) {
        this.featureDepth = pcm.getFeaturesDepth();
        if (this.metadata == null) {
            this.metadata = new PCMMetadata(pcm);
        }
        this.lines = new ArrayList<String[]>();
        this.stringWriter = new StringWriter();
        this.csvWriter = new CSVWriter((Writer)this.stringWriter, this.separator, this.quote);
        pcm.accept(this);
        if (!this.metadata.getProductAsLines().booleanValue()) {
            IOMatrix matrix = new IOMatrix(this.lines);
            matrix.transpose();
            this.lines = matrix.toList();
        }
        this.csvWriter.writeAll(this.lines);
        try {
            this.csvWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.stringWriter.toString();
    }

    public String export(PCMContainer container, char separator, char quote) {
        this.separator = separator;
        this.quote = quote;
        return this.export(container);
    }

    @Override
    public void visit(PCM pcm) {
        LinkedList<AbstractFeature> featuresToVisit = new LinkedList<AbstractFeature>();
        this.nextFeaturesToVisit = new LinkedList();
        featuresToVisit.addAll(pcm.getFeatures());
        while (!featuresToVisit.isEmpty()) {
            this.headerLine = new ArrayList<String>();
            this.headerLine.add("Product");
            Collections.sort(featuresToVisit, new Comparator<AbstractFeature>(){

                @Override
                public int compare(AbstractFeature feat1, AbstractFeature feat2) {
                    return CSVExporter.this.metadata.getFeaturePosition(feat1) - CSVExporter.this.metadata.getFeaturePosition(feat2);
                }
            });
            for (AbstractFeature feature : featuresToVisit) {
                feature.accept(this);
            }
            this.lines.add(this.headerLine.toArray(new String[this.headerLine.size()]));
            featuresToVisit = this.nextFeaturesToVisit;
            this.nextFeaturesToVisit = new LinkedList();
            --this.featureDepth;
        }
        for (Product product : this.metadata.getSortedProducts()) {
            this.productLine = new ArrayList<String>();
            product.accept(this);
            this.lines.add(this.productLine.toArray(new String[this.productLine.size()]));
        }
    }

    @Override
    public void visit(Feature feature) {
        this.headerLine.add(feature.getName());
        if (this.featureDepth > 1) {
            this.nextFeaturesToVisit.add(feature);
        }
    }

    @Override
    public void visit(FeatureGroup featureGroup) {
        for (int i = 0; i < featureGroup.getFeatures().size(); ++i) {
            this.headerLine.add(featureGroup.getName());
        }
        this.nextFeaturesToVisit.addAll(featureGroup.getFeatures());
    }

    @Override
    public void visit(Product product) {
        this.productLine.add(product.getName());
        for (Feature feature : this.metadata.getSortedFeatures()) {
            Cell cell = product.findCell(feature);
            if (cell == null) {
                this.productLine.add("");
                continue;
            }
            this.productLine.add(cell.getContent());
        }
    }

    @Override
    public void visit(Cell cell) {
    }

    @Override
    public void visit(BooleanValue booleanValue) {
    }

    @Override
    public void visit(Conditional conditional) {
    }

    @Override
    public void visit(DateValue dateValue) {
    }

    @Override
    public void visit(Dimension dimension) {
    }

    @Override
    public void visit(IntegerValue integerValue) {
    }

    @Override
    public void visit(Multiple multiple) {
    }

    @Override
    public void visit(NotApplicable notApplicable) {
    }

    @Override
    public void visit(NotAvailable notAvailable) {
    }

    @Override
    public void visit(Partial partial) {
    }

    @Override
    public void visit(RealValue realValue) {
    }

    @Override
    public void visit(StringValue stringValue) {
    }

    @Override
    public void visit(Unit unit) {
    }

    @Override
    public void visit(Version version) {
    }
}

