/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.api.java.util;

import java.util.List;
import java.util.TreeMap;
import org.opencompare.api.java.AbstractFeature;
import org.opencompare.api.java.Cell;
import org.opencompare.api.java.Product;
import org.opencompare.api.java.util.PCMElementComparator;

public class ComplexePCMElementComparator
implements PCMElementComparator {
    @Override
    public boolean similarFeature(AbstractFeature f1, AbstractFeature f2) {
        if (f1 == f2) {
            return true;
        }
        if (f1 == null || f2 == null) {
            return false;
        }
        return f1.getName().equalsIgnoreCase(f2.getName());
    }

    @Override
    public boolean similarProduct(Product p1, Product p2) {
        if (p1 == p2) {
            return true;
        }
        if (p1 == null || p2 == null) {
            return false;
        }
        return p1.getName().equals(p2.getName());
    }

    @Override
    public boolean similarCell(Cell c1, Cell c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        return c1.getContent().equalsIgnoreCase(c2.getContent());
    }

    @Override
    public Product disambiguateProduct(Product product, List<Product> products) {
        TreeMap<Integer, Product> mapping = new TreeMap<Integer, Product>();
        Object result = null;
        for (Cell cell1 : product.getCells()) {
            for (Product prod2 : products) {
                int i = product.getCells().size();
                for (Cell cell2 : prod2.getCells()) {
                    if (!cell2.getContent().equals(cell1.getContent())) continue;
                    ++i;
                }
                mapping.put(i, prod2);
            }
        }
        return (Product)mapping.pollLastEntry().getValue();
    }

    @Override
    public AbstractFeature disambiguateFeature(AbstractFeature feature, List<AbstractFeature> features) {
        TreeMap mapping = new TreeMap();
        return (AbstractFeature)mapping.pollLastEntry().getValue();
    }
}

