/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.api.java.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opencompare.api.java.AbstractFeature;
import org.opencompare.api.java.Cell;
import org.opencompare.api.java.Feature;
import org.opencompare.api.java.FeatureGroup;
import org.opencompare.api.java.PCM;
import org.opencompare.api.java.PCMElement;
import org.opencompare.api.java.PCMFactory;
import org.opencompare.api.java.Product;
import org.opencompare.api.java.Value;
import org.opencompare.api.java.exception.MergeConflictException;
import org.opencompare.api.java.impl.AbstractFeatureImpl;
import org.opencompare.api.java.impl.FeatureGroupImpl;
import org.opencompare.api.java.impl.FeatureImpl;
import org.opencompare.api.java.impl.ProductImpl;
import org.opencompare.api.java.util.DiffResult;
import org.opencompare.api.java.util.PCMElementComparator;
import org.opencompare.api.java.util.PCMVisitor;
import org.opencompare.api.java.util.Pair;

public class PCMImpl
implements PCM {
    private pcm.PCM kpcm;

    public PCMImpl(pcm.PCM kpcm) {
        this.kpcm = kpcm;
    }

    public pcm.PCM getKpcm() {
        return this.kpcm;
    }

    public String getName() {
        return this.kpcm.getName();
    }

    public void setName(String s) {
        this.kpcm.setName(s);
    }

    public List<Product> getProducts() {
        ArrayList<Product> products = new ArrayList<Product>();
        for (pcm.Product kProduct : this.kpcm.getProducts()) {
            products.add(new ProductImpl(kProduct));
        }
        return products;
    }

    public void addProduct(Product product) {
        this.kpcm.addProducts(((ProductImpl)product).getkProduct());
    }

    public void removeProduct(Product product) {
        this.kpcm.removeProducts(((ProductImpl)product).getkProduct());
    }

    public List<AbstractFeature> getFeatures() {
        ArrayList<AbstractFeature> features = new ArrayList<AbstractFeature>();
        for (pcm.AbstractFeature kFeature : this.kpcm.getFeatures()) {
            if (kFeature instanceof pcm.Feature) {
                features.add(new FeatureImpl((pcm.Feature)kFeature));
                continue;
            }
            if (!(kFeature instanceof pcm.FeatureGroup)) continue;
            features.add(new FeatureGroupImpl((pcm.FeatureGroup)kFeature));
        }
        return features;
    }

    public void addFeature(AbstractFeature abstractFeature) {
        this.kpcm.addFeatures(((AbstractFeatureImpl)abstractFeature).getkAbstractFeature());
    }

    public void removeFeature(AbstractFeature abstractFeature) {
        this.kpcm.removeFeatures(((AbstractFeatureImpl)abstractFeature).getkAbstractFeature());
    }

    public List<Feature> getConcreteFeatures() {
        List<AbstractFeature> aFeatures = this.getFeatures();
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (AbstractFeature aFeature : aFeatures) {
            features.addAll(this.getConcreteFeatures(aFeature));
        }
        return features;
    }

    private List<Feature> getConcreteFeatures(AbstractFeature aFeature) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        if (aFeature instanceof FeatureGroup) {
            FeatureGroup featureGroup = (FeatureGroup)aFeature;
            for (AbstractFeature subFeature : featureGroup.getFeatures()) {
                features.addAll(this.getConcreteFeatures(subFeature));
            }
        } else {
            features.add((Feature)aFeature);
        }
        return features;
    }

    public Feature getOrCreateFeature(String name, PCMFactory factory) {
        List<Feature> features = this.getConcreteFeatures();
        for (Feature feature : features) {
            if (!feature.getName().equals(name)) continue;
            return feature;
        }
        Feature newFeature = factory.createFeature();
        newFeature.setName(name);
        this.addFeature((AbstractFeature)newFeature);
        return newFeature;
    }

    public Product getOrCreateProduct(String name, PCMFactory factory) {
        List<Product> products = this.getProducts();
        for (Product product : products) {
            if (!product.getName().equals(name)) continue;
            return product;
        }
        Product newProduct = factory.createProduct();
        newProduct.setName(name);
        this.addProduct(newProduct);
        return newProduct;
    }

    public void accept(PCMVisitor visitor) {
        visitor.visit((PCM)this);
    }

    public void merge(PCM pcm, PCMFactory factory) throws MergeConflictException {
        this.mergeFeatures(this.getFeatures(), pcm.getFeatures(), null, factory);
        this.mergeProducts(pcm, factory);
        this.mergeCells(pcm, factory);
    }

    private void addNewFeatures(PCM pcm, PCMFactory factory) {
        for (AbstractFeature aFeature : pcm.getFeatures()) {
            boolean existInThis = false;
            for (AbstractFeature aFeatureInThis : this.getFeatures()) {
                if (!aFeature.equals(aFeatureInThis)) continue;
                existInThis = true;
                break;
            }
            if (existInThis) continue;
            Object newFeature = aFeature instanceof Feature ? factory.createFeature() : factory.createFeatureGroup();
            newFeature.setName(aFeature.getName());
            this.addFeature((AbstractFeature)newFeature);
        }
    }

    private void mergeFeatures(List<AbstractFeature> featuresPCM1, List<AbstractFeature> featuresPCM2, FeatureGroup parent, PCMFactory factory) {
        for (AbstractFeature feature2 : featuresPCM2) {
            AbstractFeature equivalentFeature = null;
            for (AbstractFeature feature1 : featuresPCM1) {
                boolean sameTypes;
                boolean sameFeatures = feature1.equals(feature2);
                boolean bl = sameTypes = feature1 instanceof Feature && feature2 instanceof Feature || feature1 instanceof FeatureGroup && feature2 instanceof FeatureGroup;
                if (!sameFeatures || !sameTypes) continue;
                equivalentFeature = feature1;
            }
            if (equivalentFeature != null) {
                if (!(equivalentFeature instanceof FeatureGroup) || !(feature2 instanceof FeatureGroup)) continue;
                FeatureGroup featureGroup1 = (FeatureGroup)equivalentFeature;
                FeatureGroup featureGroup2 = (FeatureGroup)feature2;
                this.mergeFeatures(featureGroup1.getFeatures(), featureGroup2.getFeatures(), featureGroup1, factory);
                continue;
            }
            AbstractFeature feature2Copy = (AbstractFeature)feature2.clone(factory);
            if (parent == null) {
                this.addFeature(feature2Copy);
                continue;
            }
            parent.addFeature(feature2Copy);
        }
    }

    private void mergeProducts(PCM pcm, PCMFactory factory) {
        for (Product product : pcm.getProducts()) {
            boolean existInThis = false;
            for (Product productInThis : this.getProducts()) {
                if (!product.getName().equals(productInThis.getName())) continue;
                existInThis = true;
                break;
            }
            if (existInThis) continue;
            Product newProduct = factory.createProduct();
            newProduct.setName(product.getName());
            this.addProduct(newProduct);
        }
    }

    private void mergeCells(PCM pcm, PCMFactory factory) throws MergeConflictException {
        for (Product product : this.getProducts()) {
            for (Feature feature : this.getConcreteFeatures()) {
                Cell newCell;
                Cell cellInThis = product.findCell(feature);
                Cell cellInPCM = this.findCorrespondingCell(pcm, product, feature);
                if (cellInThis == null && cellInPCM == null) {
                    newCell = factory.createCell();
                    newCell.setContent("N/A");
                    newCell.setFeature(feature);
                    newCell.setInterpretation((Value)factory.createNotAvailable());
                    product.addCell(newCell);
                    continue;
                }
                if (cellInThis == null) {
                    newCell = factory.createCell();
                    newCell.setContent(cellInPCM.getContent());
                    newCell.setFeature(feature);
                    product.addCell(newCell);
                    continue;
                }
                if (cellInPCM == null || cellInThis.getContent().equals(cellInPCM.getContent())) continue;
                throw new MergeConflictException();
            }
        }
    }

    private Cell findCorrespondingCell(PCM pcm, Product product, Feature feature) {
        Cell correspondingCell = null;
        Feature correspondingFeature = null;
        for (Feature featureInPCM : pcm.getConcreteFeatures()) {
            if (!featureInPCM.getName().equals(feature.getName())) continue;
            correspondingFeature = featureInPCM;
            break;
        }
        for (Product productInPCM : pcm.getProducts()) {
            if (!productInPCM.getName().equals(product.getName())) continue;
            correspondingCell = productInPCM.findCell(correspondingFeature);
            break;
        }
        return correspondingCell;
    }

    public boolean isValid() {
        List<Feature> features = this.getConcreteFeatures();
        HashSet<Feature> uniqueFeatures = new HashSet<Feature>(features);
        if (uniqueFeatures.size() != features.size()) {
            return false;
        }
        HashSet<Product> uniqueProducts = new HashSet<Product>(this.getProducts());
        if (uniqueProducts.size() != this.getProducts().size()) {
            return false;
        }
        for (Product product : this.getProducts()) {
            for (Feature feature : features) {
                if (product.findCell(feature) != null) continue;
                return false;
            }
        }
        return true;
    }

    public void normalize(PCMFactory factory) {
        for (Product product : this.getProducts()) {
            for (Feature feature : this.getConcreteFeatures()) {
                if (product.findCell(feature) != null) continue;
                Cell cell = factory.createCell();
                cell.setFeature(feature);
                cell.setContent("N/A");
                cell.setInterpretation((Value)factory.createNotAvailable());
                product.addCell(cell);
            }
        }
    }

    public DiffResult diff(PCM pcm, PCMElementComparator pcmElementComparator) {
        DiffResult result = new DiffResult((PCM)this, pcm);
        List<Feature> thisFeatures = this.getConcreteFeatures();
        List pcmFeatures = pcm.getConcreteFeatures();
        Map<Feature, Feature> equivalentFeatures = this.diffFeatures(thisFeatures, pcmFeatures, pcmElementComparator, result);
        Map<Product, Product> equivalentProducts = this.diffProducts(this.getProducts(), pcm.getProducts(), pcmElementComparator, result);
        this.compareCells(equivalentFeatures, equivalentProducts, pcmElementComparator, result);
        return result;
    }

    private Map<Feature, Feature> diffFeatures(List<Feature> pcm1Features, List<Feature> pcm2Features, PCMElementComparator comparator, DiffResult result) {
        ArrayList<Feature> commonFeatures = new ArrayList<Feature>();
        ArrayList<Feature> featuresOnlyInPCM1 = new ArrayList<Feature>();
        ArrayList<Feature> featuresOnlyInPCM2 = new ArrayList<Feature>(pcm2Features);
        HashMap<Feature, Feature> equivalentFeatures = new HashMap<Feature, Feature>();
        for (Feature f1 : pcm1Features) {
            boolean similarFeature = false;
            for (Feature f2 : pcm2Features) {
                similarFeature = comparator.similarFeature((AbstractFeature)f1, (AbstractFeature)f2);
                if (!similarFeature) continue;
                commonFeatures.add(f1);
                featuresOnlyInPCM2.remove(f2);
                equivalentFeatures.put(f1, f2);
                break;
            }
            if (similarFeature) continue;
            featuresOnlyInPCM1.add(f1);
        }
        result.setCommonFeatures(commonFeatures);
        result.setFeaturesOnlyInPCM1(featuresOnlyInPCM1);
        result.setFeaturesOnlyInPCM2(featuresOnlyInPCM2);
        return equivalentFeatures;
    }

    private Map<Product, Product> diffProducts(List<Product> pcm1Products, List<Product> pcm2Products, PCMElementComparator comparator, DiffResult result) {
        ArrayList<Product> commonProducts = new ArrayList<Product>();
        ArrayList<Product> productsOnlyInPCM1 = new ArrayList<Product>();
        ArrayList<Product> productsOnlyInPCM2 = new ArrayList<Product>(pcm2Products);
        HashMap<Product, Product> equivalentProducts = new HashMap<Product, Product>();
        for (Product p1 : pcm1Products) {
            boolean similarProduct = false;
            for (Product p2 : pcm2Products) {
                similarProduct = comparator.similarProduct(p1, p2);
                if (!similarProduct) continue;
                commonProducts.add(p1);
                productsOnlyInPCM2.remove(p2);
                equivalentProducts.put(p1, p2);
                break;
            }
            if (similarProduct) continue;
            productsOnlyInPCM1.add(p1);
        }
        result.setCommonProducts(commonProducts);
        result.setProductsOnlyInPCM1(productsOnlyInPCM1);
        result.setProductsOnlyInPCM2(productsOnlyInPCM2);
        return equivalentProducts;
    }

    private void compareCells(Map<Feature, Feature> equivalentFeatures, Map<Product, Product> equivalentProducts, PCMElementComparator comparator, DiffResult result) {
        ArrayList<Pair> differingCells = new ArrayList<Pair>();
        for (Feature f1 : result.getCommonFeatures()) {
            Feature f2 = equivalentFeatures.get(f1);
            for (Product p1 : result.getCommonProducts()) {
                Cell c2;
                Product p2 = equivalentProducts.get(p1);
                Cell c1 = p1.findCell(f1);
                if (comparator.similarCell(c1, c2 = p2.findCell(f2))) continue;
                differingCells.add(new Pair((Object)c1, (Object)c2));
            }
        }
        result.setDifferingCells(differingCells);
    }

    public void invert(PCMFactory factory) {
        List<Feature> originalFeatures = this.getConcreteFeatures();
        List<Product> originalProducts = this.getProducts();
        HashMap<Feature, Product> featureToProduct = new HashMap<Feature, Product>();
        for (Product originalProduct : originalProducts) {
            this.removeProduct(originalProduct);
            Feature newFeature = factory.createFeature();
            newFeature.setName(originalProduct.getName());
            this.addFeature((AbstractFeature)newFeature);
            for (Cell cell : originalProduct.getCells()) {
                Feature originalFeature = cell.getFeature();
                Product newProduct = (Product)featureToProduct.get(originalFeature);
                if (newProduct == null) {
                    this.removeFeature((AbstractFeature)originalFeature);
                    newProduct = factory.createProduct();
                    newProduct.setName(originalFeature.getName());
                    this.addProduct(newProduct);
                    featureToProduct.put(originalFeature, newProduct);
                }
                newProduct.addCell(cell);
                cell.setFeature(newFeature);
            }
        }
    }

    public int getFeaturesDepth() {
        int depth = 1;
        for (AbstractFeature abstractFeature : this.getFeatures()) {
            FeatureGroup featureGroup;
            int subdepth;
            if (!(abstractFeature instanceof FeatureGroup) || (subdepth = (featureGroup = (FeatureGroup)abstractFeature).getDepth()) <= depth) continue;
            depth = subdepth;
        }
        return depth;
    }

    public boolean equals(Object o) {
        HashSet<Product> pcmProductSet;
        HashSet<Feature> pcmConcreteFeaturesSet;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PCMImpl pcm = (PCMImpl)o;
        if (this.getName() == null && pcm.getName() != null) {
            return false;
        }
        if (this.getName() != null && !this.getName().equals(pcm.getName())) {
            return false;
        }
        HashSet<Feature> thisConcreteFeaturesSet = new HashSet<Feature>(this.getConcreteFeatures());
        if (!thisConcreteFeaturesSet.equals(pcmConcreteFeaturesSet = new HashSet<Feature>(pcm.getConcreteFeatures()))) {
            return false;
        }
        HashSet<Product> thisProductSet = new HashSet<Product>(this.getProducts());
        return thisProductSet.equals(pcmProductSet = new HashSet<Product>(pcm.getProducts()));
    }

    public int hashCode() {
        return Objects.hash(this.getName(), new HashSet<Feature>(this.getConcreteFeatures()), new HashSet<Product>(this.getProducts()));
    }

    public PCMElement clone(PCMFactory factory) {
        PCM copy = factory.createPCM();
        copy.setName(this.getName());
        for (AbstractFeature feature : this.getFeatures()) {
            copy.addFeature((AbstractFeature)feature.clone(factory));
        }
        for (Product product : this.getProducts()) {
            Product productCopy = (Product)product.clone(factory);
            copy.addProduct(productCopy);
        }
        return copy;
    }
}

