/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.api.java.impl.io;

import org.kevoree.modeling.api.KMFContainer;
import org.kevoree.modeling.api.json.JSONModelSerializer;
import org.opencompare.api.java.PCM;
import org.opencompare.api.java.PCMContainer;
import org.opencompare.api.java.impl.PCMImpl;
import org.opencompare.api.java.impl.io.PCMBase64Encoder;
import org.opencompare.api.java.io.PCMExporter;
import pcm.factory.DefaultPcmFactory;

public class KMFJSONExporter
implements PCMExporter {
    private boolean base64Encoding;
    private DefaultPcmFactory factory = new DefaultPcmFactory();
    private JSONModelSerializer serializer = this.factory.createJSONSerializer();
    private PCMBase64Encoder encoder = new PCMBase64Encoder();

    public KMFJSONExporter() {
        this(true);
    }

    public KMFJSONExporter(boolean base64Encoding) {
        this.base64Encoding = base64Encoding;
    }

    public String export(PCMContainer container) {
        return this.toJson(container.getPcm());
    }

    public String toJson(PCM pcm) {
        String json = "";
        if (pcm instanceof PCMImpl) {
            if (this.base64Encoding) {
                this.encoder.encode(pcm);
            }
            pcm.PCM kPcm = ((PCMImpl)pcm).getKpcm();
            json = this.serializer.serialize((KMFContainer)kPcm);
            if (this.base64Encoding) {
                this.encoder.decode(pcm);
            }
        }
        return json;
    }
}

