/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils;

public class BinaryPrefix {
    private final long normValue;
    private final String prefix;
    private final long factor;
    private static final String[] prefixes = new String[]{"", "Ki", "Mi", "Gi", "Ti", "Pi", "Ei"};

    public BinaryPrefix(long value) {
        int i;
        long factor = 1L;
        for (i = 0; i < prefixes.length - 1 && value >= factor * 1024L; ++i) {
            factor *= 1024L;
        }
        this.factor = factor;
        this.normValue = value / factor;
        this.prefix = prefixes[i];
    }

    public long getValue() {
        return this.normValue;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public long getFactor() {
        return this.factor;
    }

    public String makeUnit(String unit) {
        return this.prefix + unit;
    }

    public String makePaddedUnit(String unit) {
        return (this.factor == 1L ? "  " : "") + this.prefix + unit;
    }
}

