/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils;

import de.fau.cs.osr.utils.FmtIllegalArgumentException;
import de.fau.cs.osr.utils.StringUtils;
import java.io.PrintStream;

public class ConsoleProgressBar {
    private long from;
    private long to;
    private long cur;
    private float progress;
    private int barLength;
    private int lineLength = -1;
    private int indicatorStep;
    private String percentageFormatString;
    private PrintStream out;
    private int numRedraw = 0;
    private String[] indicator = new String[]{"-", "\\", "|", "/"};

    public ConsoleProgressBar(long from, long to, int barLength) {
        this.setBounds(from, to, from);
        this.setBarLength(barLength);
        this.setIndicatorStep(1);
        this.setPercentageFormatString("%5.1f");
        this.setOut(System.out);
    }

    public void setBounds(int from, int to) {
        this.checkBounds(from, to);
        this.from = from;
        this.to = to;
        this.update();
    }

    public void setBounds(long from, long to, long cur) {
        this.checkBounds(from, to);
        this.from = from;
        this.to = to;
        this.cur = cur;
        this.update();
    }

    public long getFrom() {
        return this.from;
    }

    public void setFrom(long from) {
        this.checkBounds(from, this.to);
        this.from = from;
        this.update();
    }

    public long getTo() {
        return this.to;
    }

    public void setTo(long to) {
        this.checkBounds(this.from, to);
        this.to = to;
        this.update();
    }

    public long getCur() {
        return this.cur;
    }

    public void setCur(long cur) {
        this.cur = cur;
        this.update();
    }

    protected void checkBounds(long from, long to) {
        if (to <= from) {
            throw new FmtIllegalArgumentException("Illegal bounds!", new Object[0]);
        }
    }

    public PrintStream getOut() {
        return this.out;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public float getProgress() {
        return this.progress;
    }

    public int getBarLength() {
        return this.barLength;
    }

    public void setBarLength(int barLength) {
        this.invalidate();
        this.barLength = barLength;
    }

    public int getIndicatorStep() {
        return this.indicatorStep;
    }

    public void setIndicatorStep(int indicatorStep) {
        this.invalidate();
        this.indicatorStep = indicatorStep;
    }

    public String getPercentageFormatString() {
        return this.percentageFormatString;
    }

    public void setPercentageFormatString(String percentageFormatString) {
        this.invalidate();
        this.percentageFormatString = percentageFormatString;
    }

    private void invalidate() {
        this.numRedraw = 0;
    }

    public void advance() {
        this.advance(1L);
    }

    public void advance(long step) {
        this.goTo(this.cur + step);
    }

    public void goTo(long cur) {
        this.setCur(cur);
        this.internalRedraw();
    }

    private void internalRedraw() {
        if (this.numRedraw % this.indicatorStep == 0) {
            this.redraw();
        }
        ++this.numRedraw;
    }

    public void update() {
        this.progress = (float)(this.cur - this.from) / (float)(this.to - this.from);
    }

    public void redraw() {
        String space;
        String done;
        if (this.progress <= 0.0f) {
            done = "";
            space = StringUtils.strrep(' ', this.barLength);
        } else if (this.progress >= 1.0f) {
            done = StringUtils.strrep('=', this.barLength);
            space = "";
        } else {
            int numDone = (int)((float)this.barLength * this.progress);
            done = StringUtils.strrep('=', numDone);
            space = StringUtils.strrep(' ', this.barLength - numDone);
        }
        int indPos = this.numRedraw / this.indicatorStep % this.indicator.length;
        String bar = String.format("|%s%s|%s " + this.percentageFormatString, done, space, this.indicator[indPos], Float.valueOf(this.progress * 100.0f));
        int len = bar.length();
        if (len < this.lineLength) {
            bar = bar + StringUtils.strrep(' ', this.lineLength - len);
        }
        this.lineLength = len;
        this.out.print(bar + '\r');
    }

    public void clear() {
        this.out.print(StringUtils.strrep(' ', this.lineLength) + '\r');
    }
}

