/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils;

import de.fau.cs.osr.utils.FileContent;
import de.fau.cs.osr.utils.FileUtils;
import de.fau.cs.osr.utils.TestResourcesFixture;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import org.junit.Assert;

public class FileCompare {
    private static final Object IGNORE_TEST = "IGNORE THIS TEST";
    private static Pattern inputPathToRefPathSearch;
    private static String inputPathToRefPathReplaceWith;
    private final TestResourcesFixture resources;
    private final boolean randomRefName;
    private final boolean putInitialRefFilesIntoRefFileDir;

    public FileCompare(TestResourcesFixture resources) {
        this.resources = resources;
        this.randomRefName = false;
        this.putInitialRefFilesIntoRefFileDir = false;
    }

    public FileCompare(TestResourcesFixture resources, boolean randomRefName, boolean putInitialRefFilesIntoRefFileDir) {
        this.resources = resources;
        this.randomRefName = randomRefName;
        this.putInitialRefFilesIntoRefFileDir = putInitialRefFilesIntoRefFileDir;
    }

    public void compareWithExpectedOrGenerateExpectedFromActual(File expectedFile, String actual) throws IOException {
        actual = this.fixActualText(actual);
        this.checkReferenceFile(expectedFile, actual);
        this.assertEquals(expectedFile, actual);
    }

    public String fixActualText(String actual) {
        return this.resources.stripBaseDirectoryAndFixPath(FileUtils.lineEndToUnix(actual));
    }

    private void checkReferenceFile(File expectedFile, String actual) throws IOException {
        if (!expectedFile.exists()) {
            File create;
            if (this.putInitialRefFilesIntoRefFileDir) {
                String dir = expectedFile.getParentFile().getAbsolutePath();
                FileUtils.fileSeparatorToUnix(dir);
                if (inputPathToRefPathSearch == null) {
                    inputPathToRefPathSearch = Pattern.compile("(.*?)" + Pattern.quote("/target/test-classes/"));
                }
                if (!inputPathToRefPathSearch.matcher(dir).find()) {
                    Assert.fail((String)"Reference file did not exist! FAILED TO WRITE REFERENCE FILE!");
                }
                if (inputPathToRefPathReplaceWith == null) {
                    inputPathToRefPathReplaceWith = "$1" + Pattern.quote("/src/test/resources/");
                }
                dir = inputPathToRefPathSearch.matcher(dir).replaceAll(inputPathToRefPathReplaceWith);
                create = new File(dir);
            } else {
                create = new File("").getAbsoluteFile();
            }
            create = this.randomRefName ? File.createTempFile(expectedFile.getName() + "-", "", create) : new File(create, expectedFile.getName());
            org.apache.commons.io.FileUtils.writeStringToFile((File)create, (String)actual);
            Assert.fail((String)("Reference file did not exist! Wrote initial reference file to: " + create.getAbsolutePath()));
        }
    }

    public void assertEquals(File expectedFile, String actual) throws IOException {
        FileContent reftext = new FileContent(expectedFile);
        String trimmed = reftext.getContent().trim();
        int i = trimmed.indexOf(10);
        int j = trimmed.indexOf(13);
        if (i == -1 || j != -1 && j < i) {
            i = j;
        }
        if (i != -1) {
            trimmed = trimmed.substring(0, i);
        }
        if (trimmed.equals(IGNORE_TEST)) {
            return;
        }
        String reference = FileUtils.lineEndToUnix(reftext.getContent());
        Assert.assertEquals((Object)reference, (Object)actual);
    }
}

