/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils;

import de.fau.cs.osr.utils.FileUtils;
import de.fau.cs.osr.utils.FmtFileNotFoundException;
import de.fau.cs.osr.utils.FmtIllegalArgumentException;
import java.io.File;
import java.io.IOException;

public class FileContent {
    private File file;
    private String content;

    public FileContent(File file) throws IOException {
        this.loadFile(file, "UTF-8");
    }

    public FileContent(File file, String encoding) throws IOException {
        this.loadFile(file, encoding);
    }

    protected void loadFile(File file, String encoding) throws IOException {
        if (encoding == null) {
            throw new FmtIllegalArgumentException("Argument `encoding' must not be null", new Object[0]);
        }
        if (file == null) {
            throw new FmtIllegalArgumentException("Argument `file' must not be null", new Object[0]);
        }
        if (!file.exists()) {
            throw new FmtFileNotFoundException("File not found: `%s'", file.getAbsolutePath());
        }
        this.file = file;
        String fileContent = org.apache.commons.io.FileUtils.readFileToString((File)file, (String)encoding);
        this.content = FileUtils.lineEndToUnix(fileContent);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }
}

