/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils;

import de.fau.cs.osr.utils.ReflectionUtils;
import de.fau.cs.osr.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.DualHashBidiMap;

public class NameAbbrevService {
    private final List<String> packages = new ArrayList<String>();
    private final boolean strict;
    private BidiMap cache;

    public NameAbbrevService(String ... packageNames) {
        this(true, packageNames);
    }

    public NameAbbrevService(boolean strict, String ... packageNames) {
        this.strict = strict;
        this.packages.add("java.lang");
        this.packages.addAll(Arrays.asList(packageNames));
        this.cache = new DualHashBidiMap();
        this.cache.put(Byte.TYPE, (Object)"byte");
        this.cache.put(Short.TYPE, (Object)"short");
        this.cache.put(Integer.TYPE, (Object)"int");
        this.cache.put(Long.TYPE, (Object)"long");
        this.cache.put(Float.TYPE, (Object)"float");
        this.cache.put(Double.TYPE, (Object)"double");
        this.cache.put(Boolean.TYPE, (Object)"boolean");
        this.cache.put(Character.TYPE, (Object)"char");
    }

    public String abbrev(Class<?> clazz) {
        String shortName;
        String suffix = "";
        if (clazz.isArray()) {
            ReflectionUtils.ArrayInfo info = ReflectionUtils.arrayDimension(clazz);
            clazz = info.elementClass;
            suffix = StringUtils.strrep("[]", info.dim);
        }
        if ((shortName = (String)this.cache.get(clazz)) != null) {
            return shortName + suffix;
        }
        String simpleName = clazz.getName();
        int i = simpleName.lastIndexOf(46);
        if (i >= 0) {
            simpleName = simpleName.substring(i + 1);
        }
        if (this.cache.containsValue((Object)simpleName)) {
            shortName = clazz.getName();
            this.cache.put(clazz, (Object)shortName);
            return shortName + suffix;
        }
        String dotSimpleName = "." + simpleName;
        for (String pkg : this.packages) {
            try {
                Class<?> otherClazz = Class.forName(pkg + dotSimpleName);
                this.cache.put(otherClazz, (Object)simpleName);
                if (otherClazz != clazz) {
                    shortName = clazz.getName();
                    this.cache.put(clazz, (Object)shortName);
                    return shortName + suffix;
                }
                shortName = simpleName;
                return shortName + suffix;
            }
            catch (ClassNotFoundException e) {
            }
        }
        if (!this.strict) {
            return clazz.getName() + suffix;
        }
        throw new IllegalArgumentException("Given class is not part of the package list: " + clazz.getName());
    }

    public Class<?> resolve(String abbrev) throws ClassNotFoundException {
        int dim = NameAbbrevService.getArrayDim(abbrev);
        Class<?> clazz = (Class<?>)this.cache.getKey((Object)(abbrev = abbrev.substring(0, abbrev.length() - dim * 2)));
        if (clazz != null) {
            return NameAbbrevService.arrayClassFor(clazz, dim);
        }
        if (abbrev.indexOf(46) >= 0) {
            clazz = Class.forName(abbrev);
            this.cache.put(clazz, (Object)abbrev);
            return NameAbbrevService.arrayClassFor(clazz, dim);
        }
        String dotSimpleName = "." + abbrev;
        for (String pkg : this.packages) {
            try {
                clazz = Class.forName(pkg + dotSimpleName);
                this.cache.put(clazz, (Object)abbrev);
                return NameAbbrevService.arrayClassFor(clazz, dim);
            }
            catch (ClassNotFoundException e) {
            }
        }
        throw new ClassNotFoundException("Given abbreviated class name was not found in any package of the package list: " + abbrev);
    }

    private static int getArrayDim(String abbrev) {
        int dim = 0;
        int i = abbrev.length() - 1;
        while (i >= 0 && abbrev.charAt(i) == ']' && abbrev.charAt(--i) == '[') {
            --i;
            ++dim;
        }
        return dim;
    }

    private static Class<?> arrayClassFor(Class<?> clazz, int dim) {
        if (dim == 0) {
            return clazz;
        }
        return ReflectionUtils.arrayClassFor(clazz, dim);
    }
}

