/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils;

import de.fau.cs.osr.utils.TestNameAnnotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Parameterized;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class NamedParametrized
extends Suite {
    private final ArrayList<Runner> runners = new ArrayList();

    public NamedParametrized(Class<?> clazz) throws Throwable {
        super(clazz, Collections.emptyList());
        int i = 0;
        for (Object[] parameters : this.getParametersList(this.getTestClass())) {
            this.runners.add((Runner)new TestClassRunner(this.getTestClass().getJavaClass(), parameters, i++));
        }
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }

    private List<Object[]> getParametersList(TestClass clazz) throws Throwable {
        return (List)this.getParametersMethod(clazz).invokeExplosively(null, new Object[0]);
    }

    private FrameworkMethod getParametersMethod(TestClass testClass) throws Exception {
        List methods = testClass.getAnnotatedMethods(Parameterized.Parameters.class);
        FrameworkMethod found = null;
        for (FrameworkMethod method : methods) {
            int modifiers = method.getMethod().getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
            if (found != null) {
                throw new Exception("Multiple public static methods are annotated with @Parameters in " + testClass.getName());
            }
            found = method;
        }
        if (found == null) {
            throw new Exception("Cannot find public static method annotated with @Parameters in " + testClass.getName());
        }
        return found;
    }

    private static class TestClassRunner
    extends BlockJUnit4ClassRunner {
        private final int parameterSet;
        private final Object[] parameters;
        private final String parameterSetName;

        TestClassRunner(Class<?> type, Object[] parameters, int parameterSet) throws InitializationError {
            super(type);
            this.parameters = parameters;
            this.parameterSet = parameterSet;
            this.parameterSetName = TestClassRunner.getParameterSetName(parameters);
        }

        private static String getParameterSetName(Object[] parameters) {
            Object object = parameters[0];
            if (object instanceof String) {
                return String.format("\"%s\"", (String)object);
            }
            return "<UNKNOWN>";
        }

        public Object createTest() throws Exception {
            return this.getTestClass().getOnlyConstructor().newInstance(this.parameters);
        }

        protected String getName() {
            return String.format("[%d]: %s", this.parameterSet, this.parameterSetName);
        }

        protected String testName(FrameworkMethod method) {
            TestNameAnnotation nameAnnotation = (TestNameAnnotation)method.getAnnotation(TestNameAnnotation.class);
            if (nameAnnotation == null) {
                return String.format("%s with { %s, ... }", method.getName(), this.parameterSetName);
            }
            return String.format("%s with { %s, ... }; %s", method.getName(), this.parameterSetName, nameAnnotation.annotation());
        }

        protected void validateConstructor(List<Throwable> errors) {
            this.validateOnlyOneConstructor(errors);
        }

        protected Statement classBlock(RunNotifier notifier) {
            return this.childrenInvoker(notifier);
        }
    }
}

