/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class NamedParametrizedSuites
extends Suite {
    private final ArrayList<Runner> runners = new ArrayList();

    public NamedParametrizedSuites(Class<?> clazz) throws Throwable {
        super(clazz, Collections.emptyList());
        int i = 0;
        for (NamedParametrizedSuite suite : this.getSuiteList(this.getTestClass())) {
            this.runners.add((Runner)new TestSuiteRunner(clazz, suite, i++));
        }
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }

    private List<NamedParametrizedSuite> getSuiteList(TestClass clazz) throws Throwable {
        return (List)this.getSuitesMethod(clazz).invokeExplosively(null, new Object[0]);
    }

    private FrameworkMethod getSuitesMethod(TestClass testClass) throws Exception {
        List methods = testClass.getAnnotatedMethods(Suites.class);
        FrameworkMethod found = null;
        for (FrameworkMethod method : methods) {
            int modifiers = method.getMethod().getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
            if (found != null) {
                throw new Exception("Multiple public static methods are annotated with @Suites in " + testClass.getName());
            }
            found = method;
        }
        if (found == null) {
            throw new Exception("Cannot find public static method annotated with @Suites in " + testClass.getName());
        }
        return found;
    }

    private static class TestClassRunner
    extends BlockJUnit4ClassRunner {
        private final int parameterSet;
        private final Object[] parameters;
        private final String parameterSetName;

        TestClassRunner(Class<?> type, Object[] parameters, int parameterSet) throws InitializationError {
            super(type);
            this.parameters = parameters;
            this.parameterSet = parameterSet;
            this.parameterSetName = TestClassRunner.getParameterSetName(parameters);
        }

        private static String getParameterSetName(Object[] parameters) {
            Object object = parameters[0];
            if (object instanceof String) {
                return String.format("\"%s\"", (String)object);
            }
            return "<UNKNOWN>";
        }

        public Object createTest() throws Exception {
            return this.getTestClass().getOnlyConstructor().newInstance(this.parameters);
        }

        protected String getName() {
            return String.format("[%d]: %s", this.parameterSet, this.parameterSetName);
        }

        protected String testName(FrameworkMethod method) {
            return String.format("%s with { %s, ... }", method.getName(), this.parameterSetName);
        }

        protected void validateConstructor(List<Throwable> errors) {
            this.validateOnlyOneConstructor(errors);
        }

        protected Statement classBlock(RunNotifier notifier) {
            return this.childrenInvoker(notifier);
        }
    }

    private static class TestSuiteRunner
    extends Suite {
        private final ArrayList<Runner> runners = new ArrayList();
        private final String name;
        private final String description;

        TestSuiteRunner(Class<?> clazz, NamedParametrizedSuite suiteDesc, int parameterSet) throws InitializationError {
            super(clazz, Collections.emptyList());
            this.name = suiteDesc.getSuiteName();
            this.description = suiteDesc.getSuiteDescription();
            int i = 0;
            for (Object[] parameters : suiteDesc.getTestCases()) {
                this.runners.add((Runner)new TestClassRunner(this.getTestClass().getJavaClass(), parameters, i++));
            }
        }

        protected List<Runner> getChildren() {
            return this.runners;
        }

        protected String getName() {
            return this.name;
        }
    }

    public static final class NamedParametrizedSuite
    implements Comparable<NamedParametrizedSuite> {
        private final String suiteName;
        private final String suiteDescription;
        private final List<Object[]> testCases;

        public NamedParametrizedSuite(String suiteName, String suiteDescription, List<Object[]> testCases) {
            this.suiteName = suiteName;
            this.suiteDescription = suiteDescription;
            this.testCases = testCases;
        }

        public String getSuiteName() {
            return this.suiteName;
        }

        public String getSuiteDescription() {
            return this.suiteDescription;
        }

        public List<Object[]> getTestCases() {
            return this.testCases;
        }

        @Override
        public int compareTo(NamedParametrizedSuite o) {
            return this.suiteName.compareTo(o.getSuiteName());
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Suites {
    }
}

