/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils;

import de.fau.cs.osr.utils.StringUtils;

public class SimpleConsoleOutput {
    private boolean quiet;

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void echoQuoted(String x) {
        if (!this.quiet) {
            SimpleConsoleOutput.printQuoted(x);
        }
    }

    public static void printQuoted(String x) {
        System.out.print("\"\"\"");
        System.out.print(x);
        System.out.println("\"\"\"");
    }

    public void echoSep(String title) {
        if (!this.quiet) {
            SimpleConsoleOutput.printSep(title);
        }
    }

    public static void printSep(String title) {
        System.out.println(SimpleConsoleOutput.formatSepLine(0, title));
    }

    public void echoSep(int indent, String title) {
        if (!this.quiet) {
            SimpleConsoleOutput.printSep(indent, title);
        }
    }

    public static void printSep(int indent, String title) {
        System.out.println(SimpleConsoleOutput.formatSepLine(indent, title));
    }

    public void echoBigSep(String title) {
        if (!this.quiet) {
            SimpleConsoleOutput.printBigSep(title);
        }
    }

    public static void printBigSep(String title) {
        System.out.println();
        String eq80 = StringUtils.strrep("=", 80);
        String sp76 = StringUtils.strrep(" ", 76);
        String spX = StringUtils.strrep(" ", Math.max(75 - title.length(), 1));
        System.out.println(eq80);
        System.out.println("==" + sp76 + "==");
        System.out.println("== " + title + spX + "==");
        System.out.println("==" + sp76 + "==");
        System.out.println(eq80);
        System.out.println();
    }

    public static String formatSepLine(int indent, String title) {
        String sep = StringUtils.strrep(' ', indent) + "--[ " + title + " ]";
        String line = sep + StringUtils.strrep("-", Math.max(80 - sep.length(), 2));
        return line;
    }
}

