/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils;

import de.fau.cs.osr.utils.WrappedException;
import de.fau.cs.osr.utils.XmlEntityResolver;
import de.fau.cs.osr.utils.XmlGrammar;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringEscapeUtils;

public final class StringUtils {
    public static String escHtml(String text) {
        return StringUtils.escHtml(text, true);
    }

    public static String escHtml(String text, boolean forAttribute) {
        if (text == null) {
            return "";
        }
        int n = text.length();
        StringBuilder sb = new StringBuilder(n * 4 / 3);
        block11: for (int i = 0; i < n; ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\t': 
                case '\n': 
                case ' ': {
                    sb.append(ch);
                    continue block11;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block11;
                }
                case '>': {
                    sb.append(forAttribute ? "&gt;" : ">");
                    continue block11;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block11;
                }
                case '\'': {
                    sb.append("&#39;");
                    continue block11;
                }
                case '\"': {
                    sb.append(forAttribute ? "&quot;" : "\"");
                    continue block11;
                }
                default: {
                    if (ch >= '\u0000' && ch < ' ' || ch == '\u00fe') {
                        StringUtils.hexCharRef(sb, ch);
                        continue block11;
                    }
                    if (Character.isHighSurrogate(ch)) {
                        char ch2;
                        if (++i < n && Character.isLowSurrogate(ch2 = text.charAt(i))) {
                            int codePoint = Character.toCodePoint(ch, ch2);
                            switch (Character.getType(codePoint)) {
                                case 0: 
                                case 15: 
                                case 18: {
                                    StringUtils.hexCharRef(sb, codePoint);
                                    continue block11;
                                }
                            }
                            sb.append(ch);
                            sb.append(ch2);
                            continue block11;
                        }
                    } else if (!Character.isLowSurrogate(ch)) {
                        sb.append(ch);
                        continue block11;
                    }
                    throw new IllegalArgumentException("String contains isolated surrogates!");
                }
            }
        }
        return sb.toString();
    }

    public static String escJava(String text) {
        return StringEscapeUtils.escapeJava((String)text);
    }

    public static String hexCharRef(int codePoint) {
        return String.format("&#x%X;", codePoint);
    }

    public static void hexCharRef(StringBuilder sb, int codePoint) {
        sb.append("&#x");
        sb.append(Integer.toHexString(codePoint));
        sb.append(';');
    }

    public static String entityRef(String name) {
        return String.format("&%s;", name);
    }

    public static void entityRef(StringBuilder sb, String name) {
        sb.append('&');
        sb.append(name);
        sb.append(';');
    }

    public static String join(Collection<?> c) {
        StringBuilder b = new StringBuilder();
        for (Object o : c) {
            b.append(o.toString());
        }
        return b.toString();
    }

    public static String strrep(char c, int times) {
        return org.apache.commons.lang.StringUtils.repeat((String)Character.toString(c), (int)times);
    }

    public static String strrep(String str, int times) {
        return org.apache.commons.lang.StringUtils.repeat((String)str, (int)times);
    }

    public static String crop(String str, int length) {
        return org.apache.commons.lang.StringUtils.abbreviate((String)str, (int)length);
    }

    public static String indent(String text, String indent) {
        if (text == null) {
            return "";
        }
        int n = text.length();
        StringBuilder result = new StringBuilder(n * 2);
        result.append(indent);
        block4: for (int i = 0; i < n; ++i) {
            char ch = text.charAt(i);
            result.append(ch);
            switch (ch) {
                case '\n': {
                    result.append(indent);
                    continue block4;
                }
                case '\r': {
                    if (i + 1 < n && text.charAt(i + 1) == '\n') {
                        result.append('\n');
                        ++i;
                    }
                    result.append(indent);
                }
            }
        }
        return result.toString();
    }

    public static String indent2(String text, String indent) {
        if (text == null) {
            return "";
        }
        int n = text.length();
        StringBuilder result = new StringBuilder(n * 2);
        block4: for (int i = 0; i < n; ++i) {
            char ch = text.charAt(i);
            result.append(ch);
            switch (ch) {
                case '\n': {
                    result.append(indent);
                    continue block4;
                }
                case '\r': {
                    if (i + 1 < n && text.charAt(i + 1) == '\n') {
                        result.append('\n');
                        ++i;
                    }
                    result.append(indent);
                }
            }
        }
        return result.toString();
    }

    public static String camelcaseToUppercase(String camelCase) {
        int n = camelCase.length();
        StringBuilder upperCase = new StringBuilder(n * 4 / 3);
        for (int i = 0; i < n; ++i) {
            char ch = camelCase.charAt(i);
            if (Character.isUpperCase(ch)) {
                upperCase.append('_');
                upperCase.append(ch);
                continue;
            }
            upperCase.append(Character.toUpperCase(ch));
        }
        return upperCase.toString();
    }

    public static String startWithUppercase(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.isEmpty()) {
            return name;
        }
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static boolean hasIsolatedSurrogates(String text) {
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (Character.isHighSurrogate(ch)) {
                if (++i < length) {
                    char ch2 = text.charAt(i);
                    if (Character.isLowSurrogate(ch2)) continue;
                    return true;
                }
                return true;
            }
            if (!Character.isLowSurrogate(ch)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasParagraphSeparators(String text) {
        int length = text.length();
        block4: for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (ch != '\n') continue;
            ++i;
            while (i < length) {
                char ch2 = text.charAt(i);
                switch (ch2) {
                    case '\t': 
                    case ' ': {
                        break;
                    }
                    case '\n': {
                        return true;
                    }
                    default: {
                        continue block4;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public static String trim(String text) {
        int from;
        int length = text.length();
        for (from = 0; from < length && Character.isWhitespace(text.charAt(from)); ++from) {
        }
        while (from < length && Character.isWhitespace(text.charAt(length - 1))) {
            --length;
        }
        if (from > 0 || length < text.length()) {
            return text.substring(from, length);
        }
        return text;
    }

    public static String trimUnderscores(String text) {
        int from;
        int length = text.length();
        for (from = 0; from < length && text.charAt(from) == '_'; ++from) {
        }
        while (from < length && text.charAt(length - 1) == '_') {
            --length;
        }
        if (from > 0 || length < text.length()) {
            return text.substring(from, length);
        }
        return text;
    }

    public static String trimLeft(String text) {
        int from;
        int length = text.length();
        for (from = 0; from < length && Character.isWhitespace(text.charAt(from)); ++from) {
        }
        if (from > 0) {
            return text.substring(from, length);
        }
        return text;
    }

    public static String trimRight(String text) {
        int length;
        for (length = text.length(); 0 < length && Character.isWhitespace(text.charAt(length - 1)); --length) {
        }
        if (length < text.length()) {
            return text.substring(0, length);
        }
        return text;
    }

    public static boolean isWhitespace(String text) {
        if (text == null) {
            throw new NullPointerException();
        }
        return org.apache.commons.lang.StringUtils.isWhitespace((String)text);
    }

    public static String collapseWhitespace(String trim) {
        if (trim.isEmpty()) {
            return trim;
        }
        StringBuilder b = new StringBuilder(trim.length());
        for (int i = 0; i < trim.length(); ++i) {
            char ch = trim.charAt(i);
            if (Character.isWhitespace(ch)) {
                int j;
                b.append(' ');
                for (j = i + 1; j < trim.length() && Character.isWhitespace(trim.charAt(j)); ++j) {
                }
                i = j - 1;
                continue;
            }
            b.append(ch);
        }
        return b.toString();
    }

    public static String urlDecode(String text) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '%' && i + 2 < text.length()) {
                String num = text.substring(i + 1, i + 3);
                try {
                    int val = Integer.valueOf(num, 16);
                    if (val >= 32 && val < 127) {
                        ch = (char)val;
                        i += 2;
                    }
                }
                catch (NumberFormatException e) {}
            } else if (ch == '+') {
                ch = ' ';
            }
            b.append(ch);
        }
        return b.toString();
    }

    public static String xmlDecode(String text, XmlEntityResolver resolver) {
        StringBuilder b;
        block8: {
            Matcher m;
            Pattern rx = XmlGrammar.xmlReference();
            int start = 0;
            b = new StringBuilder();
            while ((m = rx.matcher(text)).find(start)) {
                b.append(text.substring(start, m.start()));
                String resolved = null;
                if (m.group(1) != null) {
                    resolved = resolver.resolveXmlEntity(m.group(1));
                } else {
                    try {
                        boolean decimal = m.group(2) != null;
                        String num = decimal ? m.group(2) : m.group(3);
                        int val = Integer.valueOf(num, decimal ? 10 : 16);
                        if (val >= 32 && val != 127) {
                            resolved = String.valueOf((char)val);
                        }
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (resolved != null) {
                    b.append(resolved);
                } else {
                    b.append(text.substring(m.start(), m.end()));
                }
                start = m.end();
            }
            if (start >= text.length()) break block8;
            b.append(text.substring(start));
        }
        return b.toString();
    }

    public static String safeFilename(String fileTitle) {
        int MAX_LENGTH = 128;
        int ABBREV_LENGTH = 96;
        Charset utf8 = Charset.forName("UTF8");
        String abbrev = null;
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < fileTitle.length(); ++i) {
            char ch = fileTitle.charAt(i);
            switch (ch) {
                case ' ': 
                case '_': {
                    b.append(ch);
                    break;
                }
                default: {
                    if (ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z') {
                        b.append(ch);
                        break;
                    }
                    byte[] bytes = fileTitle.substring(i, i + 1).getBytes(utf8);
                    if (b.length() > 96 - 3 * bytes.length && abbrev == null) {
                        abbrev = b.toString();
                    }
                    for (byte unit : bytes) {
                        b.append(String.format("%%%02X", unit));
                    }
                }
            }
            if (b.length() < 96 || abbrev != null) continue;
            abbrev = b.toString();
        }
        String safe = b.toString();
        if (abbrev != null && safe.length() > 128) {
            safe = abbrev + "-" + DigestUtils.md5Hex((String)fileTitle);
        }
        return safe;
    }

    public static String decodeUsingDefaultCharset(String url) {
        try {
            return URLDecoder.decode(url, Charset.defaultCharset().name());
        }
        catch (UnsupportedEncodingException e) {
            throw new WrappedException(e);
        }
    }
}

