/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils;

import de.fau.cs.osr.utils.FileUtils;
import de.fau.cs.osr.utils.FmtIllegalArgumentException;
import de.fau.cs.osr.utils.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;

public class TestResourcesFixture {
    private final File baseDirectory;

    public TestResourcesFixture(File baseDirectory) throws FileNotFoundException {
        if (baseDirectory != null) {
            if (!baseDirectory.exists()) {
                throw new FileNotFoundException(String.format("Given base directory `%s' does not exist", baseDirectory));
            }
            if (!baseDirectory.isDirectory()) {
                throw new FileNotFoundException(String.format("Given base directory `%s' is not a directory", baseDirectory));
            }
            this.baseDirectory = baseDirectory;
        } else {
            this.baseDirectory = null;
        }
    }

    public TestResourcesFixture(ClassLoader classLoader, String pathToIndex) throws FileNotFoundException {
        this.baseDirectory = TestResourcesFixture.findBaseDirectory(classLoader, pathToIndex);
    }

    private static File findBaseDirectory(ClassLoader cl, String pathToIndex) throws FileNotFoundException {
        URL url = cl.getResource(String.format("%s/index", pathToIndex));
        if (url == null) {
            throw new FileNotFoundException(String.format("Cannot find index file in resource path: `%s'", pathToIndex));
        }
        String path = StringUtils.decodeUsingDefaultCharset(url.getFile());
        return new File(path).getParentFile();
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    public List<Object[]> gatherAsParameters(String inputSubDir, String filterRx, boolean recursive) {
        LinkedList<Object[]> inputs = new LinkedList<Object[]>();
        for (File file : this.gather(inputSubDir, filterRx, recursive)) {
            inputs.add(new Object[]{file.getName(), this, file});
        }
        return inputs;
    }

    public List<File> gather(String subDirectory, String pattern, final boolean recursive) {
        LinkedList<File> files = new LinkedList<File>();
        final Pattern p = Pattern.compile(pattern);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                Matcher matcher = p.matcher(name);
                if (matcher.matches()) {
                    return true;
                }
                if (recursive) {
                    return new File(dir, name).isDirectory();
                }
                return false;
            }
        };
        File dir = new File(this.baseDirectory, subDirectory);
        if (!dir.exists()) {
            throw new FmtIllegalArgumentException("Given directory `%s' does not exist", dir.getAbsolutePath());
        }
        if (!dir.isDirectory()) {
            throw new FmtIllegalArgumentException("Given directory `%s' is not a directory", dir.getAbsolutePath());
        }
        TestResourcesFixture.gatherRecursive(dir, filter, files);
        Collections.sort(files);
        return files;
    }

    private static void gatherRecursive(File directory, FilenameFilter filter, List<File> gathered) {
        String[] files = directory.list(filter);
        if (files != null) {
            for (String fileName : files) {
                File file = new File(directory, fileName);
                if (file.isDirectory()) {
                    TestResourcesFixture.gatherRecursive(file, filter, gathered);
                    continue;
                }
                gathered.add(file);
            }
        }
    }

    public String stripBaseDirectoryAndFixPath(String text) {
        String p = Pattern.quote(this.baseDirectory.getAbsolutePath());
        Pattern rx = Pattern.compile(p + "(.*?:)");
        StringBuilder b = new StringBuilder();
        Matcher m = rx.matcher(text);
        int begin = 0;
        while (m.find(begin)) {
            b.append(text.substring(begin, m.start()));
            b.append(m.group(1).replace(File.separatorChar, '/'));
            begin = m.end();
        }
        if (begin < text.length()) {
            b.append(text.substring(begin, text.length()));
        }
        return b.toString();
    }

    public static File rebase(File file, String base, String rebase) {
        String unixPath = FileUtils.fileSeparatorToUnix(file.getAbsolutePath());
        File rebasedFile = new File(unixPath.replace(base, rebase));
        if (!rebasedFile.exists()) {
            throw new FmtIllegalArgumentException("Rebased file `%s' does not exist", rebasedFile.getAbsolutePath());
        }
        return rebasedFile;
    }

    public static File rebase(File file, String base, String rebase, String ext) {
        return TestResourcesFixture.rebase(file, base, rebase, ext, false);
    }

    public static File rebase(File file, String base, String rebase, String ext, boolean noThrow) {
        String unixPath = FileUtils.fileSeparatorToUnix(file.getAbsolutePath());
        String rebased = unixPath.replace(base, rebase);
        int i = rebased.lastIndexOf(46);
        rebased = i < 0 ? rebased + "." + ext : rebased.substring(0, i + 1) + ext;
        File rebasedFile = new File(rebased);
        if (rebasedFile.exists() || noThrow) {
            return rebasedFile;
        }
        throw new FmtIllegalArgumentException("Rebased file `%s' does not exist", rebasedFile.getAbsolutePath());
    }

    public static File getResourceIndexDirectory(Class<?> clazz, String basePath) {
        File index = TestResourcesFixture.resourceNameToFile(clazz, basePath + "/index");
        return index.getParentFile();
    }

    public static File resourceNameToFile(Class<?> clazz, String testFile) {
        URL wmUrl = clazz.getResource(testFile);
        if (wmUrl != null) {
            return new File(StringUtils.decodeUsingDefaultCharset(wmUrl.getFile()));
        }
        return null;
    }

    public static String fnameToTitle(File inputFile) {
        return FilenameUtils.getBaseName((String)inputFile.getName());
    }
}

