/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils.getopt;

import de.fau.cs.osr.utils.getopt.Configuration;
import de.fau.cs.osr.utils.getopt.OptionState;
import java.util.ArrayList;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;

public final class OptionBuilder {
    private char shortOpt = '\u0000';
    private String longOpt = null;
    private String description = null;
    private String argName = null;
    private boolean optionalArg = false;
    private boolean requiredArg = false;
    private char valueSep = '\u0000';
    private String propertyKey = null;
    private boolean isFixed = false;
    private String[] defaultValues = null;
    private final Configuration config;
    private final OptionParser optionParser;

    public OptionBuilder(Configuration config, OptionParser optionParser) {
        this.config = config;
        this.optionParser = optionParser;
    }

    public void create() throws IllegalArgumentException {
        boolean hasCmdLine;
        ArrayList<String> names = new ArrayList<String>();
        OptionSpecBuilder spec = null;
        String delim = "\u0000";
        boolean bl = hasCmdLine = this.shortOpt != '\u0000' || this.longOpt != null;
        if (!hasCmdLine && this.propertyKey == null) {
            throw new IllegalArgumentException("must specify either short option, long option or property key");
        }
        if (!this.isFixed && hasCmdLine) {
            OptionSpecBuilder builder;
            if (this.shortOpt != '\u0000') {
                names.add(String.valueOf(this.shortOpt));
            }
            if (this.longOpt != null) {
                names.add(this.longOpt);
            }
            spec = builder = this.optionParser.acceptsAll(names, this.description);
            ArgumentAcceptingOptionSpec aaSpec = null;
            if (this.optionalArg) {
                aaSpec = builder.withOptionalArg();
            } else if (this.requiredArg) {
                aaSpec = builder.withRequiredArg();
            }
            if (aaSpec != null) {
                spec = aaSpec;
                if (this.argName != null) {
                    aaSpec.describedAs(this.argName);
                }
                if (this.valueSep != '\u0000') {
                    aaSpec.withValuesSeparatedBy(this.valueSep);
                    delim = String.valueOf(this.valueSep);
                }
                if (this.defaultValues != null) {
                    aaSpec.defaultsTo((Object[])this.defaultValues);
                }
            }
        }
        this.config.add(new OptionState((OptionSpec<?>)spec, (List<String>)names, this.propertyKey, this.isFixed, this.defaultValues, delim, this.argName, this.description));
    }

    public OptionBuilder withShortOpt(char shortOpt) {
        this.shortOpt = shortOpt;
        return this;
    }

    public OptionBuilder withLongOpt(String longOpt) {
        this.longOpt = longOpt;
        return this;
    }

    public OptionBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public OptionBuilder withValueSeparator(char valueSep) {
        this.valueSep = valueSep;
        return this;
    }

    public OptionBuilder withRequiredArg() {
        this.requiredArg = true;
        this.optionalArg = false;
        return this;
    }

    public OptionBuilder hasOptionalArg() {
        this.requiredArg = false;
        this.optionalArg = true;
        return this;
    }

    public OptionBuilder withArgName(String name) {
        this.argName = name;
        return this;
    }

    public OptionBuilder withPropertyKey(String propertyKey) {
        this.propertyKey = propertyKey;
        return this;
    }

    public OptionBuilder withDefault(String[] values) {
        this.defaultValues = values;
        return this;
    }

    public OptionBuilder withDefault(String value, String ... values) {
        int len = 1;
        if (values != null) {
            len += values.length;
        }
        this.defaultValues = new String[len];
        int i = 0;
        this.defaultValues[i++] = value;
        if (values != null) {
            for (String v : values) {
                this.defaultValues[i++] = v;
            }
        }
        return this;
    }

    protected OptionBuilder withIsFixed() {
        this.isFixed = true;
        return this;
    }
}

