/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils.getopt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import joptsimple.OptionSpec;

final class OptionState {
    private final OptionSpec<?> spec;
    private final List<String> names;
    private final String propertyKey;
    private final boolean isFixed;
    private final String[] defaultValues;
    private final String delim;
    private final String argName;
    private final String description;
    private boolean valid = false;

    public OptionState(OptionSpec<?> spec, List<String> names, String propertyKey, boolean isFixed, String[] defaultValues, String delim, String argName, String description) {
        this.names = names;
        this.propertyKey = propertyKey;
        this.isFixed = isFixed;
        this.spec = spec;
        this.defaultValues = defaultValues;
        this.delim = delim;
        this.argName = argName;
        this.description = description;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public List<String> getNames() {
        return this.names;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    public OptionSpec<?> getSpec() {
        return this.spec;
    }

    public boolean isFixed() {
        return this.isFixed;
    }

    public String getSafeDefaultValue() {
        List<String> values;
        if (this.defaultValues != null && !(values = Arrays.asList(this.defaultValues)).isEmpty()) {
            return values.get(0);
        }
        return null;
    }

    public List<String> getSafeDefaultValues() {
        if (this.defaultValues == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.defaultValues);
    }

    public String getSafeDelim() {
        return this.delim;
    }

    public String getArgName() {
        return this.argName;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> formatNames() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.names != null) {
            for (String n : this.names) {
                result.add((n.length() == 1 ? "-" : "--") + n);
            }
        }
        if (this.propertyKey != null) {
            result.add(this.propertyKey);
        }
        return result;
    }
}

