/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils.getopt;

import de.fau.cs.osr.utils.FmtIllegalArgumentException;
import de.fau.cs.osr.utils.getopt.Configuration;
import de.fau.cs.osr.utils.getopt.Converter;
import de.fau.cs.osr.utils.getopt.ExpectedOneOfOptionException;
import de.fau.cs.osr.utils.getopt.FailedConversionException;
import de.fau.cs.osr.utils.getopt.IllegalOptionArgumentException;
import de.fau.cs.osr.utils.getopt.IllegalOptionException;
import de.fau.cs.osr.utils.getopt.MissingOptionException;
import de.fau.cs.osr.utils.getopt.OptionBuilder;
import de.fau.cs.osr.utils.getopt.OptionEnum;
import de.fau.cs.osr.utils.getopt.OptionState;
import de.fau.cs.osr.utils.getopt.UnknownConversionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import joptsimple.OptionParser;

public final class Options {
    private final OptionParser optionParser = new OptionParser();
    private final Configuration config = new Configuration();
    private final Map<Class<?>, Converter<?>> converters = new HashMap();
    private boolean quiet = false;

    public Options() {
        Converter<String> strConv = new Converter<String>(){

            @Override
            public String convert(String option, String value) {
                return value;
            }
        };
        this.addConverter(String.class, strConv);
        Converter<Integer> intConv = new Converter<Integer>(){

            @Override
            public Integer convert(String option, String value) {
                try {
                    return Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    throw new FailedConversionException(option, value, Integer.class);
                }
            }
        };
        this.addConverter(Integer.class, intConv);
        this.addConverter(Integer.TYPE, intConv);
        Converter<Boolean> boolConv = new Converter<Boolean>(){

            @Override
            public Boolean convert(String option, String value) {
                if (value == null) {
                    return true;
                }
                String cmp = value.trim().toLowerCase();
                return cmp.equals("true") || cmp.equals("yes") || cmp.equals("1");
            }
        };
        this.addConverter(Boolean.class, boolConv);
        this.addConverter(Boolean.TYPE, boolConv);
    }

    public OptionBuilder createOption(char shortOpt) {
        return new OptionBuilder(this.config, this.optionParser).withShortOpt(shortOpt);
    }

    public OptionBuilder createOption(String longOpt) {
        return new OptionBuilder(this.config, this.optionParser).withLongOpt(longOpt);
    }

    public OptionBuilder createOption(char shortOpt, String longOpt) {
        return new OptionBuilder(this.config, this.optionParser).withShortOpt(shortOpt).withLongOpt(longOpt);
    }

    public OptionBuilder createPropertyOnlyOption(String propertyKey) {
        return new OptionBuilder(this.config, this.optionParser).withPropertyKey(propertyKey);
    }

    public void createFixedValueOption(String name, String value) {
        new OptionBuilder(this.config, this.optionParser).withIsFixed().withLongOpt(name).withPropertyKey(name).withRequiredArg().withDefault(value, new String[0]).create();
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void parse(String[] args) {
        this.config.setOptionSet(this.optionParser.parse(args));
    }

    public void load(Properties properties) {
        this.config.loadProperties(properties);
    }

    public void load(FileInputStream inputStream) throws IOException {
        Properties p = new Properties();
        p.load(inputStream);
        this.load(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            this.load(is);
        }
        finally {
            is.close();
        }
    }

    public void help(PrintStream sink) {
        this.cmdLineHelp(sink);
    }

    public void cmdLineHelp(OutputStream sink) {
        try {
            this.optionParser.printHelpOn(sink);
        }
        catch (IOException e) {
            throw new RuntimeException("Printing help message failed", e);
        }
    }

    public void propertiesHelp(PrintStream out) {
        this.config.propertiesHelp(out);
    }

    public void fixedOptionsHelp(PrintStream out) {
        this.config.fixedOptionsHelp(out);
    }

    public boolean has(String option) {
        return this.config.has(option);
    }

    public String value(String option) {
        return this.config.valueOf(option);
    }

    public String value(String option, String default_) {
        return this.config.valueOf(option, default_);
    }

    public <T> T value(String option, Class<T> clazz) {
        return this.convert(option, this.value(option), clazz);
    }

    public <T> T value(String option, Class<T> clazz, T default_) {
        T value = default_;
        if (this.has(option)) {
            value = this.convert(option, this.config.valueOfNoDefault(option), clazz);
        }
        return value;
    }

    public String[] values(String option) {
        return this.config.valuesOf(option).toArray(new String[0]);
    }

    public List<String> getFreeArguments() {
        return this.config.nonOptionArguments();
    }

    public Properties propertySubset(String prefix) {
        return this.config.propertySubset(prefix);
    }

    public <T> Converter<T> addConverter(Class<T> clazz, Converter<T> converter) {
        return this.converters.put(clazz, converter);
    }

    public void expected(char shortOpt) throws MissingOptionException {
        OptionState state = this.config.updateState(shortOpt);
        if (!this.config.has(String.valueOf(shortOpt))) {
            throw new MissingOptionException(state.formatNames());
        }
    }

    public void expected(String name) throws MissingOptionException {
        OptionState state = this.config.updateState(name);
        if (!this.config.has(name)) {
            throw new MissingOptionException(state.formatNames());
        }
    }

    public String expectedOneOf(String ... names) throws ExpectedOneOfOptionException {
        int found = 0;
        String last = null;
        for (String name : names) {
            this.config.updateState(name);
            if (!this.config.has(name)) continue;
            ++found;
            last = name;
        }
        if (found != 1) {
            throw new ExpectedOneOfOptionException(names);
        }
        return last;
    }

    public void optional(char shortOpt) {
        this.config.updateState(shortOpt);
    }

    public void optional(String longOpt) {
        this.config.updateState(longOpt);
    }

    public void ignore(char shortOpt) {
        this.ignore(shortOpt, false);
    }

    public void ignore(char shortOpt, boolean quiet) {
        if (!quiet && !this.quiet && this.config.has(String.valueOf(shortOpt))) {
            System.err.format("Option `%c' is ignored!\n", Character.valueOf(shortOpt));
        }
        this.config.updateState(shortOpt);
    }

    public void ignore(String name) {
        this.ignore(name, false);
    }

    public void ignore(String name, boolean quiet) {
        if (!quiet && !this.quiet && this.config.has(name)) {
            System.err.format("Option `%s' is ignored!\n", name);
        }
        this.config.updateState(name);
    }

    public <E extends Enum<?>> E optionOneOf(char shortOpt, Class<E> enum_) throws IllegalOptionArgumentException {
        return this.optionOneOf(String.valueOf(shortOpt), enum_);
    }

    public <E extends Enum<?>> E optionOneOf(String name, Class<E> enum_) throws IllegalOptionArgumentException {
        Enum[] values;
        OptionState state = this.config.updateState(name);
        String value = this.config.valueOf(name);
        if (value == null) {
            throw new MissingOptionException(state.formatNames());
        }
        try {
            values = (Enum[])enum_.getMethod("values", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new FmtIllegalArgumentException(e, "Argument `enum_' of illegal type", new Object[0]);
        }
        Enum actualValue = null;
        for (Enum valueType : values) {
            if (!(valueType instanceof OptionEnum)) {
                throw new FmtIllegalArgumentException("Argument `enum_' does not inherit `OptionEnum'", new Object[0]);
            }
            if (!((OptionEnum)((Object)valueType)).getOptionName().equals(value)) continue;
            actualValue = valueType;
            break;
        }
        if (actualValue == null) {
            throw new IllegalOptionArgumentException(state.formatNames(), value);
        }
        return (E)actualValue;
    }

    public void checkForInvalidOptions() throws IllegalOptionException {
        this.config.checkForInvalidOptions();
    }

    protected <T> T convert(String option, String value, Class<T> clazz) {
        Converter<?> converter = this.converters.get(clazz);
        if (converter == null) {
            throw new UnknownConversionException(option, clazz);
        }
        return (T)converter.convert(option, value);
    }
}

