/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils.visitor;

import de.fau.cs.osr.utils.visitor.VisitNotFoundException;
import de.fau.cs.osr.utils.visitor.VisitorInterface;
import de.fau.cs.osr.utils.visitor.VisitorLogic;

public abstract class VisitorBase<T>
extends VisitorInterface<T> {
    private final VisitorLogic<T> logic;

    public VisitorBase() {
        this.logic = new VisitorLogic(this);
    }

    public VisitorBase(VisitorLogic<T> logic) {
        this.logic = logic;
    }

    @Override
    protected abstract Object dispatch(T var1);

    @Override
    protected boolean before(T node) {
        return true;
    }

    @Override
    protected Object after(T node, Object result) {
        return result;
    }

    @Override
    protected Object visitNotFound(T node) {
        throw new VisitNotFoundException(this, node);
    }

    public Object go(T node) {
        if (!this.before(node)) {
            return null;
        }
        Object result = this.dispatch(node);
        return this.after(node, result);
    }

    protected final Object resolveAndVisit(T node) {
        return this.logic.resolveAndVisit(node);
    }
}

