/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils.visitor;

import de.fau.cs.osr.utils.visitor.MultipleVisitMethodsMatchException;
import de.fau.cs.osr.utils.visitor.VisitNotFoundException;
import de.fau.cs.osr.utils.visitor.VisitingException;
import de.fau.cs.osr.utils.visitor.VisitorException;
import de.fau.cs.osr.utils.visitor.VisitorInterface;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;

public class VisitorLogic<T> {
    private static final int LOWER_CAPACITY = 256;
    private static final int UPPER_CAPACITY = 384;
    private static final float LOAD_FACTOR = 0.6f;
    private static final ConcurrentHashMap<Target, Target> CACHE = new ConcurrentHashMap(256, 0.6f);
    private VisitorInterface<T> visitorImpl;

    public VisitorLogic(VisitorInterface<T> visitorImpl) {
        this.visitorImpl = visitorImpl;
    }

    public final Object go(T node) {
        if (!this.visitorImpl.before(node)) {
            return null;
        }
        Object result = this.visitorImpl.dispatch(node);
        return this.visitorImpl.after(node, result);
    }

    public void setImpl(VisitorInterface<T> visitorImpl) {
        this.visitorImpl = visitorImpl;
    }

    public VisitorInterface<T> getImpl() {
        return this.visitorImpl;
    }

    public static <T> Object dispatchTo(VisitorInterface<T> modeImpl, T n) {
        return VisitorLogic.resolveAndVisit(modeImpl, n);
    }

    protected final Object resolveAndVisit(T node) {
        return VisitorLogic.resolveAndVisit(this.visitorImpl, node);
    }

    protected static <T> Object resolveAndVisit(VisitorInterface<T> visitorImpl, T node) {
        Class<?> vClass = visitorImpl.getClass();
        Class<?> nClass = node.getClass();
        Target key = new Target(vClass, nClass);
        Target cached = CACHE.get(key);
        try {
            if (cached == null) {
                cached = VisitorLogic.findVisit(key);
            }
            if (cached.getMethod() == null) {
                return visitorImpl.visitNotFound(node);
            }
            return cached.invoke(visitorImpl, node);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof VisitingException) {
                throw (VisitingException)cause;
            }
            throw new VisitingException(node, cause);
        }
        catch (VisitingException e) {
            throw e;
        }
        catch (VisitNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VisitorException(node, (Throwable)e);
        }
    }

    private static Target findVisit(Target key) throws SecurityException {
        Target target;
        Target cached;
        Method method = null;
        final Class<?> vClass = key.getVClass();
        final Class<?> nClass = key.getNClass();
        ArrayList<Class> candidates = new ArrayList<Class>();
        ArrayDeque work = new ArrayDeque();
        work.add(nClass);
        while (!work.isEmpty()) {
            Class workItem = (Class)work.remove();
            try {
                method = vClass.getMethod("visit", workItem);
                candidates.add(workItem);
            }
            catch (NoSuchMethodException e) {
                Class superclass = workItem.getSuperclass();
                if (superclass != null) {
                    work.add(superclass);
                }
                for (Class<?> i : workItem.getInterfaces()) {
                    work.add(i);
                }
            }
        }
        if (!candidates.isEmpty()) {
            Collections.sort(candidates, new Comparator<Class<?>>(){

                @Override
                public int compare(Class<?> arg0, Class<?> arg1) {
                    if (arg0 == arg1) {
                        return 0;
                    }
                    if (arg0.isAssignableFrom(arg1)) {
                        return 1;
                    }
                    if (arg1.isAssignableFrom(arg0)) {
                        return -1;
                    }
                    throw new MultipleVisitMethodsMatchException(vClass, nClass, arg0, arg1);
                }
            });
            try {
                method = vClass.getMethod("visit", (Class)candidates.get(0));
            }
            catch (NoSuchMethodException e) {
                throw new InternalError("This cannot happen");
            }
        }
        if ((cached = CACHE.putIfAbsent(target = new Target(key, method), target)) != null) {
            return cached;
        }
        target.touch();
        if (CACHE.size() > 384) {
            VisitorLogic.sweepCache();
        }
        return target;
    }

    private static synchronized void sweepCache() {
        if (CACHE.size() <= 384) {
            return;
        }
        Object[] keys = new Target[CACHE.size()];
        Enumeration<Target> keysEnum = CACHE.keys();
        int i = 0;
        while (i < keys.length && keysEnum.hasMoreElements()) {
            keys[i++] = keysEnum.nextElement();
        }
        int length = i;
        Arrays.sort(keys, 0, length);
        int to = length - 256;
        for (int j = 0; j < to; ++j) {
            CACHE.remove(keys[j]);
        }
    }

    protected static final class Target
    implements Comparable<Target> {
        private static long useCounter = 0L;
        private long lastUse = -1L;
        private final Class<?> vClass;
        private final Class<?> nClass;
        private final Method method;

        public Target(Class<?> vClass, Class<?> nClass) {
            this.vClass = vClass;
            this.nClass = nClass;
            this.method = null;
        }

        public Target(Target key, Method method) {
            this.vClass = key.vClass;
            this.nClass = key.nClass;
            this.method = method;
        }

        public Class<?> getVClass() {
            return this.vClass;
        }

        public Class<?> getNClass() {
            return this.nClass;
        }

        public Method getMethod() {
            return this.method;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.nClass.hashCode();
            result = 31 * result + this.vClass.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            Target other = (Target)obj;
            if (this.nClass != other.nClass) {
                return false;
            }
            return this.vClass == other.vClass;
        }

        public void touch() {
            this.lastUse = ++useCounter;
        }

        public Object invoke(VisitorInterface<?> visitor, Object node) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            this.touch();
            return this.method.invoke(visitor, node);
        }

        @Override
        public int compareTo(Target o) {
            return this.lastUse < o.lastUse ? -1 : 1;
        }

        public String toString() {
            return String.format("Target [%d - %s; %s:%s]", this.lastUse, this.method != null ? "O" : "X", this.vClass.getSimpleName(), this.nClass.getSimpleName());
        }
    }
}

