/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common.ast;

import de.fau.cs.osr.ptk.common.ast.AstAbstractInnerNode;
import de.fau.cs.osr.ptk.common.ast.AstChildIterator;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.AstNodeList;
import de.fau.cs.osr.ptk.common.ast.AstStringNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import xtc.util.Pair;

public class AstNodeListImpl<T extends AstNode<T>>
extends AstAbstractInnerNode<T>
implements AstNodeList<T> {
    private static final long serialVersionUID = -3855416846550776026L;
    private ArrayList<T> children = new ArrayList();

    public AstNodeListImpl() {
    }

    public AstNodeListImpl(T child) {
        this.add(child);
    }

    public AstNodeListImpl(T car, Pair<? extends T> cdr) {
        this.add(car);
        this.addAll(cdr);
    }

    public AstNodeListImpl(T a, T b) {
        this.add(a);
        this.add(b);
    }

    public AstNodeListImpl(T a, T b, T c) {
        this.add(a);
        this.add(b);
        this.add(c);
    }

    public AstNodeListImpl(T a, T b, T c, T d) {
        this.add(a);
        this.add(b);
        this.add(c);
        this.add(d);
    }

    public AstNodeListImpl(Pair<? extends T> list) {
        this.addAll(list);
    }

    public AstNodeListImpl(Collection<? extends T> list) {
        this.addAll(list);
    }

    public AstNodeListImpl(T ... children) {
        for (T x : children) {
            this.add(x);
        }
    }

    @Override
    public int getNodeType() {
        return 2;
    }

    @Override
    public int size() {
        return this.children.size();
    }

    @Override
    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.children.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.children.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.children.toArray();
    }

    @Override
    public <S> S[] toArray(S[] a) {
        return this.children.toArray(a);
    }

    @Override
    public boolean add(T e) {
        return AstNodeListImpl.addIntern(this.children, e);
    }

    @Override
    public boolean remove(Object o) {
        return this.children.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.children.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return AstNodeListImpl.addAllIntern(this.children, c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return AstNodeListImpl.addAllIntern(this.children, index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.children.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.children.retainAll(c);
    }

    @Override
    public void clear() {
        this.children.clear();
    }

    @Override
    public T get(int index) {
        return (T)((AstNode)this.children.get(index));
    }

    @Override
    public T set(int index, T value) {
        if (value == null) {
            throw new NullPointerException("A NodeList must not contain a null element!");
        }
        switch (value.getNodeType()) {
            case 2: {
                throw new IllegalArgumentException("Must not set a single element to a NodeList");
            }
            case 4097: {
                return AstNodeListImpl.setTextIntern(this.children, index, (AstStringNode)value);
            }
        }
        return (T)((AstNode)this.children.set(index, value));
    }

    private static <S extends AstNode<S>> S setTextIntern(ArrayList<S> list, int index, AstStringNode<S> text) {
        AstNode prev;
        if (text.getContent().isEmpty()) {
            return (S)((AstNode)list.remove(index));
        }
        if (index > 0 && !text.hasAttributes() && (prev = (AstNode)list.get(index - 1)).getNodeType() == 4097 && !prev.hasAttributes()) {
            try {
                list.set(index - 1, AstNodeListImpl.mergeTextNodes((AstStringNode)prev, text));
                return (S)((AstNode)list.remove(index));
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
        }
        return (S)list.set(index, text);
    }

    @Override
    public void add(int index, T element) {
        AstNodeListImpl.addIntern(this.children, index, element);
    }

    private static <S extends AstNode<S>> boolean addIntern(ArrayList<S> list, S element) {
        return AstNodeListImpl.addIntern(list, list.size(), element);
    }

    private static <S extends AstNode<S>> boolean addIntern(ArrayList<S> list, int index, S element) {
        if (element == null) {
            return false;
        }
        switch (element.getNodeType()) {
            case 2: {
                return AstNodeListImpl.addAllIntern(list, index, element);
            }
            case 4097: {
                return AstNodeListImpl.addTextIntern(list, index, (AstStringNode)element);
            }
        }
        list.add(index, element);
        return true;
    }

    private static boolean addTextIntern(ArrayList list, int index, AstStringNode text) {
        AstNode prev;
        if (text.getContent().isEmpty()) {
            return false;
        }
        if (index > 0 && !text.hasAttributes() && (prev = (AstNode)list.get(index - 1)).getNodeType() == 4097 && !prev.hasAttributes()) {
            try {
                list.set(index - 1, AstNodeListImpl.mergeTextNodes((AstStringNode)prev, text));
                return true;
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
        }
        list.add(index, text);
        return true;
    }

    private static <S extends AstNode<S>> AstStringNode<S> mergeTextNodes(AstStringNode<S> prev, AstStringNode<S> text) throws CloneNotSupportedException {
        AstStringNode merged = (AstStringNode)prev.clone();
        merged.setContent(merged.getContent() + text.getContent());
        return merged;
    }

    private static <S extends AstNode<S>> boolean addAllIntern(ArrayList<S> list, Collection<? extends S> c) {
        boolean changed = false;
        for (AstNode n : c) {
            changed |= AstNodeListImpl.addIntern(list, n);
        }
        return changed;
    }

    private static <S extends AstNode<S>> boolean addAllIntern(ArrayList<S> list, int index, Collection<? extends S> c) {
        boolean changed = false;
        for (AstNode n : c) {
            int oldSize = list.size();
            changed |= AstNodeListImpl.addIntern(list, index, n);
            index += list.size() - oldSize;
        }
        return changed;
    }

    @Override
    public T remove(int index) {
        return (T)((AstNode)this.children.remove(index));
    }

    @Override
    public int indexOf(Object o) {
        return this.children.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.children.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return new ChildListIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new ChildListIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.children.subList(fromIndex, toIndex);
    }

    @Override
    public boolean addAll(Pair<? extends T> p) {
        boolean changed = false;
        while (!p.isEmpty()) {
            changed |= this.add((T)((AstNode)p.head()));
            p = p.tail();
        }
        return changed;
    }

    @Override
    public boolean isList() {
        return true;
    }

    @Override
    public String[] getChildNames() {
        return EMPTY_CHILD_NAMES;
    }

    @Override
    public void toString(Appendable out) throws IOException {
        out.append('[');
        boolean first = true;
        for (AstNode node : this) {
            if (first) {
                first = false;
            } else {
                out.append(", ");
            }
            node.toString(out);
        }
        out.append(']');
    }

    @Override
    public void exchange(AstNodeList<T> other) {
        if (other instanceof AstNodeListImpl) {
            AstNodeListImpl other2 = (AstNodeListImpl)other;
            ArrayList<T> tmp = this.children;
            this.children = other2.children;
            other2.children = tmp;
        } else {
            AstNodeListImpl<T> tmp = new AstNodeListImpl<T>(other);
            this.exchange(tmp);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AstNodeListImpl clone = (AstNodeListImpl)super.clone();
        clone.children = new ArrayList<T>(this.children);
        return clone;
    }

    private final class ChildListIterator
    implements AstChildIterator<T> {
        private ListIterator<T> i;
        private T current = null;
        private final int start;

        public ChildListIterator() {
            this.start = 0;
            this.reset();
        }

        public ChildListIterator(int index) {
            this.start = index;
            this.reset();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public T next() {
            this.current = (AstNode)this.i.next();
            return this.current;
        }

        @Override
        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        @Override
        public T previous() {
            this.current = (AstNode)this.i.previous();
            return this.current;
        }

        @Override
        public int nextIndex() {
            return this.i.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.i.previousIndex();
        }

        @Override
        public void remove() {
            this.i.remove();
            this.current = null;
        }

        @Override
        public void set(T e) {
            if (e == null) {
                throw new NullPointerException("A NodeList must not contain a null element!");
            }
            switch (e.getNodeType()) {
                case 2: {
                    throw new IllegalArgumentException("Must not set a single element to a NodeList");
                }
                case 4097: {
                    this.setTextIntern((AstStringNode)e);
                    break;
                }
                default: {
                    this.i.set(e);
                    this.current = e;
                }
            }
        }

        private void setTextIntern(AstStringNode<T> text) {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (text.getContent().isEmpty()) {
                this.i.remove();
                this.current = null;
            } else {
                if (this.i.hasPrevious() && !text.hasAttributes()) {
                    this.i.previous();
                    if (this.i.hasPrevious()) {
                        AstNode prev = (AstNode)this.i.previous();
                        if (prev.getNodeType() == 4097 && !prev.hasAttributes()) {
                            try {
                                this.i.set(AstNodeListImpl.mergeTextNodes((AstStringNode)prev, text));
                                this.i.next();
                                this.i.next();
                                this.i.remove();
                                this.i.previous();
                                this.next();
                                return;
                            }
                            catch (CloneNotSupportedException cloneNotSupportedException) {
                                // empty catch block
                            }
                        }
                        this.i.next();
                    }
                    this.i.next();
                }
                this.i.set(text);
            }
        }

        @Override
        public void add(T e) {
            if (e != null) {
                this.current = null;
                switch (e.getNodeType()) {
                    case 2: {
                        for (AstNode n : (AstNodeList)e) {
                            this.i.add(n);
                        }
                        break;
                    }
                    case 4097: {
                        this.addTextIntern((AstStringNode)e);
                        break;
                    }
                    default: {
                        this.i.add(e);
                    }
                }
            }
        }

        private void addTextIntern(AstStringNode<T> text) {
            if (!text.getContent().isEmpty()) {
                AstNode prev;
                if (this.i.hasPrevious() && !text.hasAttributes() && (prev = (AstNode)this.i.previous()).getNodeType() == 4097 && !prev.hasAttributes()) {
                    try {
                        this.i.set(AstNodeListImpl.mergeTextNodes((AstStringNode)prev, text));
                        this.i.next();
                        return;
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        // empty catch block
                    }
                }
                this.i.add(text);
            }
        }

        @Override
        public T get() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            return this.current;
        }

        @Override
        public void reset() {
            this.i = AstNodeListImpl.this.children.listIterator(this.start);
        }
    }
}

