/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common.ast;

import de.fau.cs.osr.ptk.common.ast.AstLocation;
import de.fau.cs.osr.utils.StringUtils;
import java.io.Serializable;
import xtc.tree.Location;

public final class Span
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String content;
    private final AstLocation from;
    private final AstLocation to;

    public Span() {
        this.content = null;
        this.to = this.from = new AstLocation("Unknown file", -1, -1);
    }

    public Span(AstLocation from, AstLocation to, String content) {
        this.content = content;
        this.from = from;
        this.to = to;
    }

    public Span(AstLocation from, String content) {
        this.content = content;
        this.from = from;
        this.to = from;
    }

    public Span(Location from, Location to, String content) {
        this.content = content;
        this.from = new AstLocation(from);
        this.to = new AstLocation(to);
    }

    public Span(Location from, String content) {
        this.content = content;
        this.to = this.from = new AstLocation(from);
    }

    public String getContent() {
        return this.content;
    }

    public AstLocation getFrom() {
        return this.from;
    }

    public AstLocation getTo() {
        return this.to;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.content == null ? 0 : this.content.hashCode());
        result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
        result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Span other = (Span)obj;
        if (this.content == null ? other.content != null : !this.content.equals(other.content)) {
            return false;
        }
        if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
            return false;
        }
        return !(this.to == null ? other.to != null : !this.to.equals(other.to));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.from == null) {
            buf.append("<no location>");
        } else {
            String file = this.from.getFile();
            if (file == null || file.isEmpty()) {
                file = "<no file>";
            }
            buf.append(file);
            buf.append(':');
            buf.append(this.from.getLine());
            buf.append(':');
            buf.append(this.from.getColumn());
            if (this.to != null && !this.to.equals(this.from)) {
                buf.append(" - ");
                if (this.from.getLine() != this.to.getLine()) {
                    buf.append(this.to.getLine());
                    buf.append(':');
                }
                buf.append(this.to.getColumn());
            }
        }
        if (this.content != null) {
            buf.append(": \"");
            buf.append(StringUtils.escJava((String)StringUtils.crop((String)this.content, (int)32)));
            buf.append('\"');
        } else {
            buf.append(": <no content>");
        }
        return buf.toString();
    }
}

