/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common.comparer;

import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.comparer.AstComparisonException;
import de.fau.cs.osr.ptk.common.comparer.AstDifference;
import de.fau.cs.osr.utils.StringUtils;
import java.io.IOException;
import java.io.Writer;

public class AttributeComparisonException
extends AstComparisonException {
    private static final long serialVersionUID = 1L;
    private final String attributeName;
    private final Object aAttributeValue;
    private final Object bAttributeValue;

    public AttributeComparisonException(AstNode<?> a, AstNode<?> b, String attributeName, Object aAttributeValue, Object bAttributeValue) {
        this(null, a, b, attributeName, aAttributeValue, bAttributeValue);
    }

    public AttributeComparisonException(AstComparisonException e, AstNode<?> a, AstNode<?> b, String attributeName, Object aAttributeValue, Object bAttributeValue) {
        super(e, a, b, AstDifference.ATTRIBUTE_VALUE_DIFFERS);
        this.attributeName = attributeName;
        this.aAttributeValue = aAttributeValue;
        this.bAttributeValue = bAttributeValue;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public Object getAttributeAValue() {
        return this.aAttributeValue;
    }

    public Object getAttributeBValue() {
        return this.bAttributeValue;
    }

    @Override
    public Writer toString(Writer w) throws IOException {
        if (this.getCause() != null) {
            ((AstComparisonException)((Object)this.getCause())).toString(w);
        }
        w.append(String.format("Value of attribute `%s' differs between nodes of type %s:\n", this.attributeName, this.getA().getNodeName()));
        this.printValue("a", this.aAttributeValue, w);
        this.printValue("b", this.bAttributeValue, w);
        return w;
    }

    private void printValue(String which, Object value, Writer w) throws IOException {
        w.append("\t");
        w.append(which);
        w.append(": ");
        if (value == null) {
            w.append("null\n");
        } else {
            w.append("\"\"\"");
            w.append(StringUtils.escJava((String)value.toString()));
            w.append("\"\"\"\n");
        }
    }
}

