/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common.comparer;

import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.comparer.AstComparisonException;
import de.fau.cs.osr.ptk.common.comparer.AstDifference;
import de.fau.cs.osr.utils.StringUtils;
import java.io.IOException;
import java.io.Writer;

public class PropertyComparisonException
extends AstComparisonException {
    private static final long serialVersionUID = 1L;
    private final String propertyName;
    private final Object aPropertyValue;
    private final Object bPropertyValue;

    public PropertyComparisonException(AstComparisonException e, AstNode<?> a, AstNode<?> b, String propertyName, Object aPropertyValue, Object bPropertyValue) {
        super(e, a, b, AstDifference.PROPERTY_VALUE_DIFFERS);
        this.propertyName = propertyName;
        this.aPropertyValue = aPropertyValue;
        this.bPropertyValue = bPropertyValue;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Object getPropertyAValue() {
        return this.aPropertyValue;
    }

    public Object getPropertyBValue() {
        return this.bPropertyValue;
    }

    @Override
    public Writer toString(Writer w) throws IOException {
        if (this.getCause() != null) {
            ((AstComparisonException)((Object)this.getCause())).toString(w);
        }
        w.append(String.format("Value of property `%s' differs between nodes of type %s:\n", this.propertyName, this.getA().getNodeName()));
        this.printValue("a", this.aPropertyValue, w);
        this.printValue("b", this.bPropertyValue, w);
        return w;
    }

    private void printValue(String which, Object value, Writer w) throws IOException {
        w.append("\t");
        w.append(which);
        w.append(": ");
        if (value == null) {
            w.append("null\n");
        } else {
            w.append("\"\"\"");
            w.append(StringUtils.escJava((String)value.toString()));
            w.append("\"\"\"\n");
        }
    }
}

