/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common.jxpath;

import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.jxpath.AstNodeFieldIterator;
import de.fau.cs.osr.ptk.common.jxpath.AstNodePointer;
import de.fau.cs.osr.ptk.common.jxpath.AstPropertyIterator;
import de.fau.cs.osr.ptk.common.jxpath.AstPropertyPointer;
import de.fau.cs.osr.utils.FmtInternalLogicError;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;

public class AstNodeFieldPointer
extends NodePointer {
    private static final long serialVersionUID = 1L;
    private AstNode<?> node;
    private int fieldIndex;

    public AstNodeFieldPointer(NodePointer parent, AstNode<?> node, int index) {
        super(parent);
        this.node = node;
        this.fieldIndex = index;
    }

    public NodeIterator attributeIterator(QName name) {
        return new AstPropertyIterator(this, name);
    }

    public NodeIterator childIterator(NodeTest test, boolean reverse, NodePointer startWith) {
        AstNode pointee = (AstNode)this.getImmediateNode();
        if (this.isLeaf()) {
            return null;
        }
        if (pointee.isNodeType(2)) {
            return new AstNodeFieldIterator(this, test, reverse, startWith);
        }
        return new AstNodeFieldIterator(new AstNodePointer(this, pointee), test, reverse, startWith);
    }

    public boolean isLeaf() {
        AstNode pointee = (AstNode)this.getImmediateNode();
        return pointee == null || pointee.isEmpty();
    }

    public boolean isActual() {
        return true;
    }

    public boolean isCollection() {
        return false;
    }

    public int getLength() {
        return 1;
    }

    public QName getName() {
        return new QName(null, this.getSimpleName());
    }

    public Object getBaseValue() {
        return this.getImmediateNode();
    }

    public Object getImmediateNode() {
        return this.node.get(this.fieldIndex);
    }

    public void setValue(Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int compareChildNodePointers(NodePointer pointer1, NodePointer pointer2) {
        if (pointer1.getBaseValue() == pointer2.getBaseValue()) {
            return 0;
        }
        boolean p1IsProp = pointer1 instanceof AstPropertyPointer;
        boolean p2IsProp = pointer2 instanceof AstPropertyPointer;
        if (p1IsProp && !p2IsProp) {
            return -1;
        }
        if (!p1IsProp && p2IsProp) {
            return 1;
        }
        if (p1IsProp && p2IsProp) {
            AstPropertyPointer p1 = (AstPropertyPointer)pointer1;
            AstPropertyPointer p2 = (AstPropertyPointer)pointer2;
            int cmp = p1.getName2().compareTo(p2.getName2());
            if (cmp == 0) {
                throw new FmtInternalLogicError();
            }
            return cmp;
        }
        AstNode node1 = (AstNode)pointer1.getBaseValue();
        AstNode node2 = (AstNode)pointer2.getBaseValue();
        for (AstNode child : (AstNode)this.getImmediateNode()) {
            if (child == node1) {
                return -1;
            }
            if (child != node2) continue;
            return 1;
        }
        throw new FmtInternalLogicError();
    }

    public int hashCode() {
        return this.getImmediateNode().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AstNodeFieldPointer other = (AstNodeFieldPointer)((Object)obj);
        return this.getImmediateNode() == other.getImmediateNode();
    }

    public String asPath() {
        StringBuffer buffer = new StringBuffer();
        if (this.parent != null) {
            buffer.append(this.parent.asPath());
        }
        if (this.parent instanceof AstNodePointer || this.parent instanceof AstNodeFieldPointer) {
            if (buffer.length() == 0 || buffer.charAt(buffer.length() - 1) != '/') {
                buffer.append('/');
            }
            buffer.append(this.getSimpleName());
            if (this.parent != null) {
                buffer.append('[');
                buffer.append(this.getRelativePosition());
                buffer.append(']');
            }
        }
        return buffer.toString();
    }

    private int getRelativePosition() {
        if (this.parent != null) {
            if (this.parent instanceof AstNodePointer || this.parent instanceof AstNodeFieldPointer) {
                NodePointer p = this.parent;
                AstNode thisNode = (AstNode)this.getImmediateNode();
                int i = 1;
                for (AstNode n : (AstNode)p.getImmediateNode()) {
                    if (n == thisNode) {
                        return i;
                    }
                    ++i;
                }
                throw new FmtInternalLogicError();
            }
            return 1;
        }
        return 1;
    }

    public boolean testNode(NodeTest test) {
        if (test == null) {
            return true;
        }
        if (test instanceof NodeNameTest) {
            String s2;
            NodeNameTest nodeNameTest = (NodeNameTest)test;
            QName testName = nodeNameTest.getNodeName();
            if (testName.getPrefix() != null) {
                return false;
            }
            if (nodeNameTest.isWildcard()) {
                return true;
            }
            String s1 = this.getSimpleName();
            return s1 == (s2 = testName.getName()) || s1.equals(s2);
        }
        if (test instanceof NodeTypeTest) {
            NodeTypeTest nodeTypeTest = (NodeTypeTest)test;
            switch (nodeTypeTest.getNodeType()) {
                case 1: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private String getSimpleName() {
        return this.node.getChildNames()[this.fieldIndex];
    }
}

