/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common.jxpath;

import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.AstNodePropertyIterator;
import de.fau.cs.osr.ptk.common.ast.NoSuchPropertyException;
import de.fau.cs.osr.ptk.common.jxpath.AstPropertyPointer;
import java.util.Map;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;

public class AstPropertyIterator
implements NodeIterator {
    private NodePointer parent;
    private Property[] properties;
    private int position = 0;

    public AstPropertyIterator(NodePointer parent, QName qname) {
        this.parent = parent;
        AstNode node = (AstNode)parent.getNode();
        this.properties = null;
        if (qname.getPrefix() == null) {
            String name = qname.getName();
            if (name.equals("*")) {
                Map<String, Object> props = node.getAttributes();
                int size = node.getPropertyCount() + props.size();
                this.properties = new Property[size];
                int i = 0;
                AstNodePropertyIterator j = node.propertyIterator();
                while (j.next()) {
                    this.properties[i++] = new Property(node, j.getName(), j.getValue());
                }
                for (Map.Entry<String, Object> prop : props.entrySet()) {
                    this.properties[i++] = new Property(node, prop);
                }
            } else {
                Object value = null;
                try {
                    value = node.getProperty(name);
                }
                catch (NoSuchPropertyException e) {
                    value = node.getAttribute(name);
                }
                if (value != null) {
                    this.properties = new Property[]{new Property(node, name, value)};
                }
            }
        }
        if (this.properties == null) {
            this.properties = new Property[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodePointer getNodePointer() {
        Property prop;
        block3: {
            prop = null;
            if (this.position != 0 || this.setPosition(1)) break block3;
            NodePointer nodePointer = null;
            return nodePointer;
        }
        prop = this.properties[this.position - 1];
        AstPropertyPointer astPropertyPointer = new AstPropertyPointer(this.parent, prop);
        return astPropertyPointer;
    }

    public int getPosition() {
        return this.position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setPosition(int position) {
        block3: {
            if (position < 1 || position > this.properties.length) break block3;
            this.position = position;
            boolean bl = true;
            return bl;
        }
        boolean bl = false;
        return bl;
    }

    public static final class Property {
        private final AstNode<?> owner;
        private final String name;
        private final Object value;

        public Property(AstNode<?> owner, String name, Object value) {
            this.owner = owner;
            this.name = name;
            this.value = value;
        }

        public Property(AstNode<?> owner, Map.Entry<String, Object> entry) {
            this.owner = owner;
            this.name = entry.getKey();
            this.value = entry.getValue();
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Property other = (Property)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.owner == null ? other.owner != null : !this.owner.equals(other.owner)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public String toString() {
            return "AstNodeProperty [name=" + this.name + ", value=" + this.value + "]";
        }
    }
}

