/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jdk8;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.Optional;

final class OptionalSerializer
extends StdSerializer<Optional<?>>
implements ContextualSerializer {
    protected final JavaType _optionalType;
    protected final JsonSerializer<Object> _valueSerializer;

    public OptionalSerializer(JavaType type) {
        this(type, null);
    }

    protected OptionalSerializer(JavaType type, JsonSerializer<?> valueSer) {
        super(type);
        this._optionalType = type;
        this._valueSerializer = valueSer;
    }

    protected OptionalSerializer withResolved(BeanProperty property, JsonSerializer<?> ser) {
        if (this._valueSerializer == ser) {
            return this;
        }
        return new OptionalSerializer(this._optionalType, ser);
    }

    public boolean isEmpty(Optional<?> value) {
        return value == null || !value.isPresent();
    }

    public boolean isEmpty(SerializerProvider provider, Optional<?> value) {
        return this.isEmpty(value);
    }

    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        JsonSerializer<Object> ser = this._valueSerializer;
        if (ser == null) {
            boolean realType;
            JavaType valueType = this._valueType();
            boolean bl = realType = !valueType.hasRawClass(Object.class);
            if (realType && (provider.isEnabled(MapperFeature.USE_STATIC_TYPING) || valueType.isFinal())) {
                return this.withResolved(property, provider.findPrimaryPropertySerializer(valueType, property));
            }
        } else {
            return this.withResolved(property, provider.handlePrimaryContextualization(ser, property));
        }
        return this;
    }

    public void serialize(Optional<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (value.isPresent()) {
            if (this._valueSerializer != null) {
                this._valueSerializer.serialize(value.get(), jgen, provider);
            } else {
                provider.defaultSerializeValue(value.get(), jgen);
            }
        } else {
            provider.defaultSerializeNull(jgen);
        }
    }

    public void serializeWithType(Optional<?> value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        if (value.isPresent()) {
            JsonSerializer ser = this._valueSerializer;
            if (ser == null) {
                ser = provider.findValueSerializer(this._valueType(), null);
            }
            ser.serializeWithType(value.get(), jgen, provider, typeSer);
        } else {
            provider.defaultSerializeNull(jgen);
        }
    }

    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JavaType valueType = this._valueType();
        if (valueType != null) {
            JsonSerializer ser = this._valueSerializer;
            if (ser == null) {
                ser = visitor.getProvider().findValueSerializer(valueType, null);
            }
            ser.acceptJsonFormatVisitor(visitor, valueType);
        } else {
            super.acceptJsonFormatVisitor(visitor, typeHint);
        }
    }

    protected JavaType _valueType() {
        JavaType valueType = this._optionalType.containedType(0);
        if (valueType == null) {
            valueType = TypeFactory.unknownType();
        }
        return valueType;
    }
}

