/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.ws.ssl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.libs.ws.ssl.KeyStoreBuilder;
import play.api.libs.ws.ssl.KeystoreFormats$;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001A4A!\u0001\u0002\u0001\u001b\tAb)\u001b7f\u0005\u0006\u001cX\rZ&fsN#xN]3Ck&dG-\u001a:\u000b\u0005\r!\u0011aA:tY*\u0011QAB\u0001\u0003oNT!a\u0002\u0005\u0002\t1L'm\u001d\u0006\u0003\u0013)\t1!\u00199j\u0015\u0005Y\u0011\u0001\u00029mCf\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u0017\u001b\u0005\u0011\u0011BA\f\u0003\u0005=YU-_*u_J,')^5mI\u0016\u0014\b\u0002C\r\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\u0002\u0019-,\u0017p\u0015;pe\u0016$\u0016\u0010]3\u0011\u0005mqbBA\b\u001d\u0013\ti\u0002#\u0001\u0004Qe\u0016$WMZ\u0005\u0003?\u0001\u0012aa\u0015;sS:<'BA\u000f\u0011\u0011!\u0011\u0003A!A!\u0002\u0013Q\u0012\u0001\u00034jY\u0016\u0004\u0016\r\u001e5\t\u0011\u0011\u0002!\u0011!Q\u0001\n\u0015\n\u0001\u0002]1tg^|'\u000f\u001a\t\u0004\u001f\u0019B\u0013BA\u0014\u0011\u0005\u0019y\u0005\u000f^5p]B\u0019q\"K\u0016\n\u0005)\u0002\"!B!se\u0006L\bCA\b-\u0013\ti\u0003C\u0001\u0003DQ\u0006\u0014\b\"B\u0018\u0001\t\u0003\u0001\u0014A\u0002\u001fj]&$h\b\u0006\u00032eM\"\u0004CA\u000b\u0001\u0011\u0015Ib\u00061\u0001\u001b\u0011\u0015\u0011c\u00061\u0001\u001b\u0011\u0015!c\u00061\u0001&\u0011\u001d1\u0004A1A\u0005\u0002]\na\u0001\\8hO\u0016\u0014X#\u0001\u001d\u0011\u0005erT\"\u0001\u001e\u000b\u0005mb\u0014!B:mMRR'\"A\u001f\u0002\u0007=\u0014x-\u0003\u0002@u\t1Aj\\4hKJDa!\u0011\u0001!\u0002\u0013A\u0014a\u00027pO\u001e,'\u000f\t\u0005\u0006\u0007\u0002!\t\u0001R\u0001\u0006EVLG\u000e\u001a\u000b\u0002\u000bB\u0011aiS\u0007\u0002\u000f*\u0011\u0001*S\u0001\tg\u0016\u001cWO]5us*\t!*\u0001\u0003kCZ\f\u0017B\u0001'H\u0005!YU-_*u_J,\u0007\"\u0002(\u0001\t\u0003y\u0015!\u00062vS2$gI]8n\u0017\u0016L8\u000f^8sK\u001aKG.\u001a\u000b\u0004\u000bB\u0013\u0006\"B)N\u0001\u0004Q\u0012!C:u_J,G+\u001f9f\u0011\u0015\u0019V\n1\u0001U\u0003\u00111\u0017\u000e\\3\u0011\u0005UCV\"\u0001,\u000b\u0005]K\u0015AA5p\u0013\tIfK\u0001\u0003GS2,\u0007\"B.\u0001\t\u0003a\u0016\u0001\u0005:fC\u0012\u001cUM\u001d;jM&\u001c\u0017\r^3t)\tiv\u000eE\u0002_M&t!a\u00183\u000f\u0005\u0001\u001cW\"A1\u000b\u0005\td\u0011A\u0002\u001fs_>$h(C\u0001\u0012\u0013\t)\u0007#A\u0004qC\u000e\\\u0017mZ3\n\u0005\u001dD'\u0001C%uKJ\f'\r\\3\u000b\u0005\u0015\u0004\u0002C\u00016n\u001b\u0005Y'B\u00017H\u0003\u0011\u0019WM\u001d;\n\u00059\\'aC\"feRLg-[2bi\u0016DQa\u0015.A\u0002Q\u0003")
public class FileBasedKeyStoreBuilder
implements KeyStoreBuilder {
    private final String keyStoreType;
    public final String play$api$libs$ws$ssl$FileBasedKeyStoreBuilder$$filePath;
    private final Option<char[]> password;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    @Override
    public KeyStore build() {
        KeyStore keyStore;
        File file = new File(this.play$api$libs$ws$ssl$FileBasedKeyStoreBuilder$$filePath);
        Predef$.MODULE$.require(file.exists(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileBasedKeyStoreBuilder $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Key store file ", " does not exist!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.play$api$libs$ws$ssl$FileBasedKeyStoreBuilder$$filePath}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.require(file.canRead(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileBasedKeyStoreBuilder $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot read from key store file ", "!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.play$api$libs$ws$ssl$FileBasedKeyStoreBuilder$$filePath}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String string = this.keyStoreType;
        if ("PEM".equals(string)) {
            Iterable<Certificate> certs = this.readCertificates(file);
            keyStore = KeystoreFormats$.MODULE$.loadCertificates((TraversableOnce<Certificate>)certs);
        } else {
            keyStore = this.buildFromKeystoreFile(string, file);
        }
        return keyStore;
    }

    /*
     * WARNING - void declaration
     */
    public KeyStore buildFromKeystoreFile(String storeType, File file) {
        KeyStore keyStore;
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            String storeType2 = this.keyStoreType;
            KeyStore store = KeyStore.getInstance(storeType2);
            store.load(inputStream, (char[])this.password.orNull(Predef$.MODULE$.$conforms()));
            keyStore = store;
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        inputStream.close();
        return keyStore;
    }

    public Iterable<Certificate> readCertificates(File file) {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        FileInputStream fis = new FileInputStream(file);
        BufferedInputStream bis = new BufferedInputStream(fis);
        return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(cf.generateCertificates(bis)).asScala();
    }

    public FileBasedKeyStoreBuilder(String keyStoreType, String filePath, Option<char[]> password) {
        this.keyStoreType = keyStoreType;
        this.play$api$libs$ws$ssl$FileBasedKeyStoreBuilder$$filePath = filePath;
        this.password = password;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }
}

