/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.ws.ssl.debug;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.libs.ws.ssl.JavaSecurityDebugBuilder;
import play.api.libs.ws.ssl.JavaxNetDebugBuilder;
import play.api.libs.ws.ssl.SSLDebugConfig;
import play.api.libs.ws.ssl.debug.FixCertpathDebugLogging$;
import play.api.libs.ws.ssl.debug.FixInternalDebugLogging$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001q2A!\u0001\u0002\u0001\u001f\t\u0011B)\u001a2vO\u000e{gNZ5hkJ\fG/[8o\u0015\t\u0019A!A\u0003eK\n,xM\u0003\u0002\u0006\r\u0005\u00191o\u001d7\u000b\u0005\u001dA\u0011AA<t\u0015\tI!\"\u0001\u0003mS\n\u001c(BA\u0006\r\u0003\r\t\u0007/\u001b\u0006\u0002\u001b\u0005!\u0001\u000f\\1z\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g\u0011\u00159\u0002\u0001\"\u0001\u0019\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u001b\u00015\t!\u0001C\u0004\u001d\u0001\t\u0007I\u0011B\u000f\u0002\r1|wmZ3s+\u0005q\u0002CA\u0010%\u001b\u0005\u0001#BA\u0011#\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005\u0019\u0013aA8sO&\u0011Q\u0005\t\u0002\u0007\u0019><w-\u001a:\t\r\u001d\u0002\u0001\u0015!\u0003\u001f\u0003\u001dawnZ4fe\u0002BQ!\u000b\u0001\u0005\u0002)\n\u0011bY8oM&<WO]3\u0015\u0005-r\u0003CA\t-\u0013\ti#C\u0001\u0003V]&$\b\"B\u0018)\u0001\u0004\u0001\u0014!\u00013\u0011\u0005E\u0012T\"\u0001\u0003\n\u0005M\"!AD*T\u0019\u0012+'-^4D_:4\u0017n\u001a\u0005\u0006k\u0001!\tAN\u0001\u0017G>tg-[4ve\u0016T\u0015M^1y\u001d\u0016$H)\u001a2vOR\u00111f\u000e\u0005\u0006_Q\u0002\r\u0001\r\u0005\u0006s\u0001!\tAO\u0001\u001bG>tg-[4ve\u0016T\u0015M^1TK\u000e,(/\u001b;z\t\u0016\u0014Wo\u001a\u000b\u0003WmBQa\f\u001dA\u0002A\u0002")
public class DebugConfiguration {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    private Logger logger() {
        return this.logger;
    }

    public void configure(SSLDebugConfig d) {
        this.configureJavaxNetDebug(d);
        this.configureJavaSecurityDebug(d);
    }

    public void configureJavaxNetDebug(SSLDebugConfig d) {
        String netDebugOptions = new JavaxNetDebugBuilder(d).build();
        this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"configureJavaxNetDebug: d = ", ", netDebugOptions = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{d, netDebugOptions})));
        FixInternalDebugLogging$.MODULE$.apply(netDebugOptions);
    }

    public void configureJavaSecurityDebug(SSLDebugConfig d) {
        String securityOptions = new JavaSecurityDebugBuilder(d).build();
        this.logger().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"configureJavaSecurityDebug: d = ", ", securityOptions = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{d, securityOptions})));
        System.setProperty("java.security.debug", securityOptions);
        FixCertpathDebugLogging$.MODULE$.apply(securityOptions, FixCertpathDebugLogging$.MODULE$.apply$default$2());
    }
}

