/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine;

import org.sweble.wikitext.engine.ExpansionException;
import org.sweble.wikitext.engine.PageTitle;
import org.sweble.wikitext.engine.nodes.EngLogProcessingPass;

public final class EngineException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final PageTitle pageTitle;
    private EngLogProcessingPass log;

    public EngineException(PageTitle pageTitle, String message, Throwable cause) {
        this(pageTitle, message, cause, null);
    }

    public EngineException(PageTitle pageTitle, String message, Throwable cause, EngLogProcessingPass log) {
        super(EngineException.makeMessage(pageTitle, message), EngineException.unwrap(cause));
        this.pageTitle = pageTitle;
        this.log = log;
    }

    private static String makeMessage(PageTitle pageTitle, String message) {
        return String.format("%s (%s)", message, pageTitle.getDenormalizedFullTitle());
    }

    private static Throwable unwrap(Throwable t) {
        while (t instanceof ExpansionException) {
            t = t.getCause();
        }
        return t;
    }

    public void attachLog(EngLogProcessingPass log) {
        if (this.log != null) {
            throw new IllegalStateException("Log already attached!");
        }
        this.log = log;
    }

    public PageTitle getPageTitle() {
        return this.pageTitle;
    }

    public EngLogProcessingPass getLog() {
        return this.log;
    }
}

