/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine;

import de.fau.cs.osr.ptk.common.Warning;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.AstNodeList;
import de.fau.cs.osr.utils.StopWatch;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sweble.wikitext.engine.ExpansionDebugHooks;
import org.sweble.wikitext.engine.ExpansionException;
import org.sweble.wikitext.engine.ExpansionFrame;
import org.sweble.wikitext.engine.FullPage;
import org.sweble.wikitext.engine.InvalidNameWarning;
import org.sweble.wikitext.engine.InvalidPagenameWarning;
import org.sweble.wikitext.engine.NodeTypeEngVisitor;
import org.sweble.wikitext.engine.PageNotFoundWarning;
import org.sweble.wikitext.engine.PageTitle;
import org.sweble.wikitext.engine.ParserFunctionBase;
import org.sweble.wikitext.engine.PfnArgumentMode;
import org.sweble.wikitext.engine.RecursiveTransclusionException;
import org.sweble.wikitext.engine.TagExtensionBase;
import org.sweble.wikitext.engine.WtEngineImpl;
import org.sweble.wikitext.engine.config.Namespace;
import org.sweble.wikitext.engine.config.WikiConfig;
import org.sweble.wikitext.engine.nodes.EngLogContainer;
import org.sweble.wikitext.engine.nodes.EngLogMagicWordResolution;
import org.sweble.wikitext.engine.nodes.EngLogParameterResolution;
import org.sweble.wikitext.engine.nodes.EngLogParserFunctionResolution;
import org.sweble.wikitext.engine.nodes.EngLogRedirectResolution;
import org.sweble.wikitext.engine.nodes.EngLogTagExtensionResolution;
import org.sweble.wikitext.engine.nodes.EngLogTransclusionResolution;
import org.sweble.wikitext.engine.nodes.EngProcessedPage;
import org.sweble.wikitext.engine.nodes.EngineNodeFactory;
import org.sweble.wikitext.engine.utils.EngineAstTextUtils;
import org.sweble.wikitext.parser.WikitextWarning;
import org.sweble.wikitext.parser.nodes.WtName;
import org.sweble.wikitext.parser.nodes.WtNewline;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtNodeList;
import org.sweble.wikitext.parser.nodes.WtPageSwitch;
import org.sweble.wikitext.parser.nodes.WtRedirect;
import org.sweble.wikitext.parser.nodes.WtTagExtension;
import org.sweble.wikitext.parser.nodes.WtTagExtensionBody;
import org.sweble.wikitext.parser.nodes.WtTemplate;
import org.sweble.wikitext.parser.nodes.WtTemplateArgument;
import org.sweble.wikitext.parser.nodes.WtTemplateParameter;
import org.sweble.wikitext.parser.nodes.WtText;
import org.sweble.wikitext.parser.nodes.WtValue;
import org.sweble.wikitext.parser.nodes.WtXmlAttribute;
import org.sweble.wikitext.parser.nodes.WtXmlAttributes;
import org.sweble.wikitext.parser.parser.LinkTargetException;
import org.sweble.wikitext.parser.utils.AstTextUtils;
import org.sweble.wikitext.parser.utils.StringConversionException;

public final class ExpansionVisitor
extends NodeTypeEngVisitor {
    private static final Pattern STARTS_WITH_BLOCK_ELEMENT = Pattern.compile("^(\\{\\||:|;|#|\\*)");
    private static final String SKIP_ATTR_NAME = "__SKIP__";
    private final ExpansionFrame expFrame;
    private final EngLogContainer frameLog;
    private final ExpansionDebugHooks hooks;
    private final boolean timingEnabled;
    private final boolean catchAll;
    private final EngineNodeFactory nf;
    private final EngineAstTextUtils tu;
    private boolean hadNewlineGlobal;

    public ExpansionVisitor(ExpansionFrame expFrame, EngLogContainer frameLog, ExpansionDebugHooks hooks, boolean timingEnabled, boolean catchAll) {
        this.expFrame = expFrame;
        this.frameLog = frameLog;
        this.hooks = hooks;
        this.timingEnabled = timingEnabled;
        this.catchAll = catchAll;
        this.nf = expFrame.getWikiConfig().getNodeFactory();
        this.tu = expFrame.getWikiConfig().getAstTextUtils();
    }

    protected WtNode visitUnspecific(WtNode n) {
        this.mapInPlace((AstNode)n);
        return n;
    }

    @Override
    protected Object resolveAndVisit(WtNode n, int type) throws ExpansionException {
        switch (type) {
            case 4097: {
                return this.visitText((WtText)n);
            }
            case 196610: {
                return this.visitNewline((WtNewline)n);
            }
            case 1245188: {
                return this.visitError(n);
            }
            case 2: 
            case 196613: 
            case 458754: {
                return this.visitUnspecific(n);
            }
        }
        this.hadNewlineGlobal = false;
        switch (type) {
            case 458760: {
                return this.visit((WtRedirect)n);
            }
            case 458758: {
                return this.visit((WtTemplateParameter)n);
            }
            case 458756: {
                return this.visit((WtTemplate)n);
            }
            case 458755: {
                return this.visit((WtTagExtension)n);
            }
            case 720939: {
                return this.visit((WtPageSwitch)n);
            }
        }
        return this.visitUnspecific(n);
    }

    private WtNewline visitNewline(WtNewline n) {
        this.hadNewlineGlobal = true;
        return n;
    }

    private WtText visitText(WtText n) {
        String text = n.getContent();
        if (!text.isEmpty()) {
            this.hadNewlineGlobal = false;
            if (text.indexOf(10) != -1) {
                this.hadNewlineGlobal = true;
            }
        }
        return n;
    }

    private Object visitError(WtNode n) {
        return n;
    }

    private WtNode visit(WtRedirect n) throws ExpansionException {
        if (this.skip((WtNode)n)) {
            return n;
        }
        if (this.expFrame.isNoRedirect()) {
            return n;
        }
        if (!n.getTarget().isResolved()) {
            return this.markError((WtNode)n);
        }
        String target = n.getTarget().getAsString();
        WtNode result = this.resolveRedirectWrapper(n, target);
        if (result == null) {
            result = this.markError((WtNode)n);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WtNode resolveRedirectWrapper(WtRedirect n, String target) throws ExpansionException {
        WtNode cont;
        if (this.hooks != null && (cont = this.hooks.beforeResolveRedirect(this, n, target)) != ExpansionDebugHooks.PROCEED) {
            return cont;
        }
        EngLogRedirectResolution log = null;
        if (this.frameLog != null) {
            log = this.nf.logRedirectResolution(target, false);
            this.frameLog.add((AstNode)log);
        }
        StopWatch stopWatch = null;
        if (this.timingEnabled) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        WtNode result = null;
        try {
            result = this.expandRedirectionTargetPage(n, target, log);
        }
        catch (Exception e) {
            result = this.markError((WtNode)n, e);
            if (log != null) {
                this.logUnhandledException(log, e);
            }
            if (!this.catchAll) {
                throw new ExpansionException(e);
            }
        }
        finally {
            if (this.timingEnabled && log != null) {
                log.setTimeNeeded(stopWatch.getElapsedTime());
            }
        }
        return this.hooks != null ? this.hooks.afterResolveRedirect(this, n, target, result, log) : result;
    }

    private WtNode expandRedirectionTargetPage(WtRedirect n, String target, EngLogRedirectResolution log) throws Exception {
        FullPage page;
        PageTitle title;
        try {
            title = PageTitle.make(this.getWikiConfig(), target);
        }
        catch (LinkTargetException e) {
            if (log != null) {
                log.add((AstNode)this.nf.logParserError(e.getMessage()));
            }
            this.fileInvalidPageNameWarning((WtNode)n, target);
            return n;
        }
        if (log != null) {
            log.setCanonical(title.getDenormalizedFullTitle());
        }
        if ((page = this.getWikitext(title)) != null) {
            EngProcessedPage processedPage = this.getEngine().preprocessAndExpand(this.expFrame.getCallback(), page.getId(), page.getText(), this.expFrame.isForInclusion(), this.expFrame.getEntityMap(), this.expFrame.getArguments(), this.expFrame.getRootFrame(), this.expFrame);
            log.setSuccess(true);
            return this.mergeLogsAndWarnings(log, processedPage);
        }
        this.filePageNotFoundWarning((WtNode)n, title);
        return null;
    }

    private WtNode visit(WtTemplate n) throws ExpansionException {
        if (this.skip((WtNode)n)) {
            return n;
        }
        boolean hadNewline = this.hadNewlineGlobal;
        WtName name = (WtName)this.dispatch((AstNode)n.getName());
        AstTextUtils.PartialConversion nameConv = this.tu.astToTextPartial((WtNode)name);
        ArrayList<WtTemplateArgument> args = new ArrayList<WtTemplateArgument>(n.getArgs().size() + 1);
        for (Object arg : n.getArgs()) {
            args.add((WtTemplateArgument)arg);
        }
        WtNode result = this.resolveTemplateAsPfn(n, nameConv.getText(), nameConv.getTail(), args, hadNewline);
        if (result == null) {
            if (nameConv.getTail().isEmpty()) {
                if (args.isEmpty()) {
                    result = this.resolveTemplateAsMagicWord(n, nameConv.getText(), hadNewline);
                }
                if (result == null) {
                    result = this.resolveTemplateAsTransclusion(n, nameConv.getText(), args, hadNewline);
                }
            } else {
                StringConversionException e = new StringConversionException((WtNode)nameConv.getTail());
                if (this.frameLog != null) {
                    this.frameLog.add((AstNode)this.nf.logParserError(e.getMessage()));
                }
                this.fileInvalidTemplateNameWarning(n, e);
            }
        }
        if (result == null) {
            result = this.markError((WtNode)n);
        } else if (result != n) {
            this.hadNewlineGlobal = this.endedWithNewline(result);
        }
        return result;
    }

    private boolean endedWithNewline(WtNode result) {
        return false;
    }

    private WtNode resolveTemplateAsPfn(WtTemplate n, String title, WtNodeList tail, ArrayList<WtTemplateArgument> args, boolean hadNewline) throws ExpansionException {
        int i = title.indexOf(58);
        if (i == -1) {
            return null;
        }
        String name = title.substring(0, i).trim() + ":";
        ParserFunctionBase pfn = this.getWikiConfig().getParserFunction(name);
        if (pfn == null) {
            return null;
        }
        String arg0Prefix = title.substring(i + 1).trim();
        List<? extends WtNode> argsValues = this.preparePfnArguments(pfn.getArgMode(), arg0Prefix, tail, args);
        return this.invokePfn(n, pfn, argsValues, hadNewline);
    }

    private List<? extends WtNode> preparePfnArguments(PfnArgumentMode pfnArgumentMode, String arg0Prefix, WtNodeList tail, List<WtTemplateArgument> args) {
        switch (pfnArgumentMode) {
            case EXPANDED_AND_TRIMMED_VALUES: {
                ArrayList<Object> argValues = new ArrayList<Object>(args.size() + 1);
                WtNodeList arg0 = this.nf.list(new Object[]{this.nf.text(arg0Prefix), tail});
                arg0 = this.tu.trim((WtNode)this.dispatch((AstNode)arg0));
                argValues.add(arg0);
                for (int j = 0; j < args.size(); ++j) {
                    WtTemplateArgument tmplArg = args.get(j);
                    WtNodeList arg = this.nf.list();
                    if (tmplArg.hasName()) {
                        arg.addAll((Collection)tmplArg.getName());
                        arg.add((Object)this.nf.text("="));
                    }
                    arg.addAll((Collection)tmplArg.getValue());
                    argValues.add(this.tu.trim((WtNode)this.dispatch((AstNode)arg)));
                }
                return argValues;
            }
            case TEMPLATE_ARGUMENTS: {
                ArrayList<WtTemplateArgument> argsWithArg0 = new ArrayList<WtTemplateArgument>(args.size() + 1);
                argsWithArg0.add(this.nf.tmplArg(this.nf.value(this.nf.list(new Object[]{this.nf.text(arg0Prefix), tail}))));
                for (WtTemplateArgument arg : args) {
                    argsWithArg0.add(arg);
                }
                return argsWithArg0;
            }
            case UNEXPANDED_VALUES: {
                ArrayList<WtNodeList> argValues = new ArrayList<WtNodeList>(args.size() + 1);
                argValues.add(this.nf.list(new Object[]{this.nf.text(arg0Prefix), tail}));
                for (int j = 0; j < args.size(); ++j) {
                    WtTemplateArgument arg = args.get(j);
                    WtNodeList value = this.nf.list();
                    if (arg.hasName()) {
                        value.addAll((Collection)arg.getName());
                        value.add((Object)this.nf.text("="));
                    }
                    value.addAll((Collection)arg.getValue());
                    argValues.add(value);
                }
                return argValues;
            }
        }
        throw new InternalError();
    }

    private WtNode resolveTemplateAsMagicWord(WtTemplate n, String title, boolean hadNewline) throws ExpansionException {
        ParserFunctionBase pfn = this.getWikiConfig().getParserFunction(title);
        if (pfn == null) {
            return null;
        }
        List argsValues = Collections.emptyList();
        return this.invokePfn(n, pfn, argsValues, hadNewline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WtNode invokePfn(WtTemplate n, ParserFunctionBase pfn, List<? extends WtNode> argsValues, boolean hadNewline) throws ExpansionException {
        WtNode cont;
        if (this.hooks != null && (cont = this.hooks.beforeResolveParserFunction(this, n, pfn, argsValues)) != ExpansionDebugHooks.PROCEED) {
            return cont;
        }
        EngLogParserFunctionResolution log = null;
        if (this.frameLog != null) {
            log = this.nf.logParserFunctionResolution(pfn.getId(), false);
            this.frameLog.add((AstNode)log);
        }
        StopWatch stopWatch = null;
        if (this.timingEnabled) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        WtNode result = null;
        try {
            result = pfn.invoke((WtNode)n, this.expFrame, argsValues);
            if (result == null) {
                throw new NullPointerException("Parser function `" + pfn.getId() + "' returned null value!");
            }
            if (result != n) {
                result = this.treatBlockElements(n, result);
            }
            log.setSuccess(true);
        }
        catch (Exception e) {
            result = this.markError((WtNode)n, e);
            if (log != null) {
                this.logUnhandledException(log, e);
            }
            if (!this.catchAll) {
                throw new ExpansionException(e);
            }
        }
        finally {
            if (this.timingEnabled && log != null) {
                log.setTimeNeeded(stopWatch.getElapsedTime());
            }
        }
        return this.hooks != null ? this.hooks.afterResolveParserFunction(this, n, pfn, argsValues, result, log) : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WtNode resolveTemplateAsTransclusion(WtTemplate n, String title, ArrayList<WtTemplateArgument> args, boolean hadNewline) throws ExpansionException {
        WtNode cont;
        if (this.hooks != null && (cont = this.hooks.beforeResolveTransclusion(this, n, title, args)) != ExpansionDebugHooks.PROCEED) {
            return cont;
        }
        EngLogTransclusionResolution log = null;
        if (this.frameLog != null) {
            log = this.nf.logTransclusionResolution(title, false);
            this.frameLog.add((AstNode)log);
        }
        StopWatch stopWatch = null;
        if (this.timingEnabled) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        WtNode result = null;
        try {
            result = this.transcludePage(n, title, args, log);
        }
        catch (Exception e) {
            result = this.markError((WtNode)n, e);
            if (log != null) {
                this.logUnhandledException(log, e);
            }
            if (!this.catchAll) {
                throw new ExpansionException(e);
            }
        }
        finally {
            if (this.timingEnabled && log != null) {
                log.setTimeNeeded(stopWatch.getElapsedTime());
            }
        }
        return this.hooks != null ? this.hooks.afterResolveTransclusion(this, n, title, args, result, log) : result;
    }

    private WtNode transcludePage(WtTemplate n, String target, List<WtTemplateArgument> args, EngLogTransclusionResolution log) throws Exception {
        PageTitle title;
        Namespace tmplNs = this.getWikiConfig().getTemplateNamespace();
        try {
            title = PageTitle.make(this.getWikiConfig(), target, tmplNs);
        }
        catch (LinkTargetException e) {
            if (log != null) {
                log.add((AstNode)this.nf.logParserError(e.getMessage()));
            }
            this.fileInvalidPageNameWarning((WtNode)n, target);
            return n;
        }
        this.checkTransclusionRecursion(title);
        log.setCanonical(title.getDenormalizedFullTitle());
        FullPage page = this.getWikitext(title);
        if (page != null) {
            Map<String, WtNodeList> tmplArgs = this.prepareTransclusionArguments(args, log);
            EngProcessedPage processedPage = this.getEngine().preprocessAndExpand(this.expFrame.getCallback(), page.getId(), page.getText(), true, this.expFrame.getEntityMap(), tmplArgs, this.expFrame.getRootFrame(), this.expFrame);
            log.setSuccess(true);
            WtNodeList tResult = this.mergeLogsAndWarnings(log, processedPage);
            return this.treatBlockElements(n, (WtNode)tResult);
        }
        this.filePageNotFoundWarning((WtNode)n, title);
        return null;
    }

    private void checkTransclusionRecursion(PageTitle title) throws RecursiveTransclusionException {
        int count = 0;
        for (ExpansionFrame f = this.expFrame; f != null; f = f.getParentFrame()) {
            if (!f.getTitle().equals(title) || ++count <= 2) continue;
            throw new RecursiveTransclusionException(title, count);
        }
    }

    private Map<String, WtNodeList> prepareTransclusionArguments(List<WtTemplateArgument> args, EngLogTransclusionResolution log) {
        HashMap<String, WtNodeList> transclArgs = new HashMap<String, WtNodeList>();
        int index = 1;
        for (WtTemplateArgument arg : args) {
            WtValue value = (WtValue)this.dispatch((AstNode)arg.getValue());
            boolean named = false;
            if (arg.hasName()) {
                value = (WtValue)this.tu.trim((WtNode)value);
                WtName name = (WtName)this.dispatch((AstNode)arg.getName());
                try {
                    String nameStr = this.tu.astToText((WtNode)name).trim();
                    if (!nameStr.isEmpty()) {
                        transclArgs.put(nameStr, this.nf.toList((AstNode)value));
                        named = true;
                    }
                }
                catch (StringConversionException e) {
                    if (log != null) {
                        log.add((AstNode)this.nf.logParserError(e.getMessage()));
                    }
                    this.fileInvalidArgumentNameWarning(arg, e);
                }
            }
            if (named) continue;
            String id = String.valueOf(index);
            WtNodeList prev = transclArgs.put(id, this.nf.toList((AstNode)value));
            if (prev != null) {
                transclArgs.put(id, prev);
            }
            ++index;
        }
        return transclArgs;
    }

    private WtNode visit(WtTemplateParameter n) throws ExpansionException {
        if (this.skip((WtNode)n)) {
            return n;
        }
        WtName name = (WtName)this.dispatch((AstNode)n.getName());
        String nameStr = null;
        try {
            nameStr = this.tu.astToText((WtNode)name);
        }
        catch (StringConversionException e) {
            if (this.frameLog != null) {
                this.frameLog.add((AstNode)this.nf.logParserError(e.getMessage()));
            }
            this.fileInvalidParameterNameWarning(n, e);
        }
        WtNode value = null;
        if (nameStr != null) {
            value = this.resolveParameterWrapper(n, nameStr.trim());
        }
        if (value == null) {
            value = this.markError((WtNode)n);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WtNode resolveParameterWrapper(WtTemplateParameter n, String name) throws ExpansionException {
        WtNode cont;
        if (this.hooks != null && (cont = this.hooks.beforeResolveParameter(this, n, name)) != ExpansionDebugHooks.PROCEED) {
            return cont;
        }
        EngLogParameterResolution log = null;
        if (this.frameLog != null) {
            log = this.nf.logParameterResolution(name, false);
            this.frameLog.add((AstNode)log);
        }
        StopWatch stopWatch = null;
        if (this.timingEnabled) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        WtNodeList result = null;
        try {
            result = this.resolveParameter(n, name, log);
        }
        catch (Exception e) {
            result = this.markError((WtNode)n, e);
            if (log != null) {
                this.logUnhandledException(log, e);
            }
            if (!this.catchAll) {
                throw new ExpansionException(e);
            }
        }
        finally {
            if (this.timingEnabled && log != null) {
                log.setTimeNeeded(stopWatch.getElapsedTime());
            }
        }
        return this.hooks != null ? this.hooks.afterResolveParameter(this, n, name, (WtNode)result, log) : result;
    }

    private WtNodeList resolveParameter(WtTemplateParameter n, String name, EngLogParameterResolution log) {
        WtNodeList value = this.getFrameArgument(name);
        if (value == null && n.hasDefault()) {
            value = this.nf.toList((AstNode)((WtValue)this.dispatch((AstNode)n.getDefault())));
        }
        if (value != null) {
            log.setSuccess(true);
        }
        return value;
    }

    private WtNode visit(WtTagExtension n) throws ExpansionException {
        if (this.skip((WtNode)n)) {
            return n;
        }
        WtNode result = this.resolveTagExtensionWrapper(n, n.getName(), n.getXmlAttributes(), n.getBody());
        if (result == null) {
            result = this.markError((WtNode)n);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WtNode resolveTagExtensionWrapper(WtTagExtension n, String name, WtXmlAttributes attrs, WtTagExtensionBody wtTagExtensionBody) throws ExpansionException {
        WtNode cont;
        if (this.hooks != null && (cont = this.hooks.beforeResolveTagExtension(this, n, name, (WtNodeList)attrs, wtTagExtensionBody)) != ExpansionDebugHooks.PROCEED) {
            return cont;
        }
        EngLogTagExtensionResolution log = null;
        if (this.frameLog != null) {
            log = this.nf.logTagExtensionResolution(name, false);
            this.frameLog.add((AstNode)log);
        }
        StopWatch stopWatch = null;
        if (this.timingEnabled) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        WtNode result = null;
        try {
            result = this.resolveTagExtension(n, name, attrs, wtTagExtensionBody, log);
        }
        catch (Exception e) {
            result = this.markError((WtNode)n, e);
            if (log != null) {
                this.logUnhandledException(log, e);
            }
            if (!this.catchAll) {
                throw new ExpansionException(e);
            }
        }
        finally {
            if (this.timingEnabled && log != null) {
                log.setTimeNeeded(stopWatch.getElapsedTime());
            }
        }
        return this.hooks != null ? this.hooks.afterResolveTagExtension(this, n, name, (WtNodeList)attrs, wtTagExtensionBody, result, log) : result;
    }

    private WtNode resolveTagExtension(WtTagExtension n, String name, WtXmlAttributes attrs, WtTagExtensionBody wtTagExtensionBody, EngLogTagExtensionResolution log) {
        TagExtensionBase te = this.getWikiConfig().getTagExtension(name);
        if (te == null) {
            return null;
        }
        HashMap<String, WtNodeList> attrMap = this.prepareTagExtensionAttributes(attrs);
        WtNode result = te.invoke(this.expFrame, n, attrMap, wtTagExtensionBody);
        log.setSuccess(true);
        return result;
    }

    private HashMap<String, WtNodeList> prepareTagExtensionAttributes(WtXmlAttributes attrs) {
        HashMap<String, WtNodeList> attrMap = new HashMap<String, WtNodeList>();
        for (WtNode attr : attrs) {
            WtXmlAttribute a;
            if (!attr.isNodeType(720929) || !(a = (WtXmlAttribute)attr).getName().isResolved()) continue;
            attrMap.put(a.getName().getAsString(), this.nf.toList((AstNode)a.getValue()));
        }
        return attrMap;
    }

    private WtNode visit(WtPageSwitch n) throws ExpansionException {
        if (this.skip((WtNode)n)) {
            return n;
        }
        WtNode result = this.resolveMagicWordWrapper(n, n.getName());
        if (result == null) {
            result = this.markError((WtNode)n);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WtNode resolveMagicWordWrapper(WtPageSwitch n, String name) throws ExpansionException {
        WtNode cont;
        if (this.hooks != null && (cont = this.hooks.beforeResolvePageSwitch(this, n, name)) != ExpansionDebugHooks.PROCEED) {
            return cont;
        }
        EngLogMagicWordResolution log = null;
        if (this.frameLog != null) {
            log = this.nf.logMagicWordResolution(name, false);
            this.frameLog.add((AstNode)log);
        }
        StopWatch stopWatch = null;
        if (this.timingEnabled) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        WtNode result = null;
        try {
            result = this.resolvePageSwitch(n, name, log);
        }
        catch (Exception e) {
            result = this.markError((WtNode)n, e);
            if (log != null) {
                this.logUnhandledException(log, e);
            }
            if (!this.catchAll) {
                throw new ExpansionException(e);
            }
        }
        finally {
            if (this.timingEnabled && log != null) {
                log.setTimeNeeded(stopWatch.getElapsedTime());
            }
        }
        return this.hooks != null ? this.hooks.afterResolvePageSwitch(this, n, name, result, log) : result;
    }

    private WtNode resolvePageSwitch(WtPageSwitch n, String name, EngLogMagicWordResolution log) {
        ParserFunctionBase mw = this.getWikiConfig().getPageSwitch("__" + name + "__");
        if (mw == null) {
            throw new InternalError("Cannot find tag extension: " + name);
        }
        WtNode result = mw.invoke((WtNode)n, this.expFrame, Collections.emptyList());
        log.setSuccess(true);
        return result;
    }

    public ExpansionFrame getExpFrame() {
        return this.expFrame;
    }

    public boolean isHadNewline() {
        return this.hadNewlineGlobal;
    }

    private WikiConfig getWikiConfig() {
        return this.expFrame.getWikiConfig();
    }

    private WtEngineImpl getEngine() {
        return this.expFrame.getEngine();
    }

    private WtNodeList getFrameArgument(String name) {
        return this.expFrame.getArguments().get(name);
    }

    private FullPage getWikitext(PageTitle title) throws Exception {
        return this.expFrame.getCallback().retrieveWikitext(this.expFrame, title);
    }

    private void logUnhandledException(EngLogContainer log, Exception e) {
        StringWriter w = new StringWriter();
        e.printStackTrace(new PrintWriter(w));
        log.add((AstNode)this.nf.logUnhandledError(e, w.toString()));
    }

    private void fileInvalidPageNameWarning(WtNode n, String target) {
        this.expFrame.fileWarning((Warning)new InvalidPagenameWarning(WikitextWarning.WarningSeverity.FATAL, ((Object)((Object)this)).getClass(), n, target));
    }

    private void fileInvalidTemplateNameWarning(WtTemplate n, StringConversionException e) {
        this.expFrame.fileWarning((Warning)new InvalidNameWarning(WikitextWarning.WarningSeverity.FATAL, ((Object)((Object)this)).getClass(), (WtNode)n));
    }

    private void fileInvalidArgumentNameWarning(WtTemplateArgument n, StringConversionException e) {
        this.expFrame.fileWarning((Warning)new InvalidNameWarning(WikitextWarning.WarningSeverity.FATAL, ((Object)((Object)this)).getClass(), (WtNode)n));
    }

    private void fileInvalidParameterNameWarning(WtTemplateParameter n, StringConversionException e) {
        this.expFrame.fileWarning((Warning)new InvalidNameWarning(WikitextWarning.WarningSeverity.FATAL, ((Object)((Object)this)).getClass(), (WtNode)n));
    }

    private void filePageNotFoundWarning(WtNode n, PageTitle title) {
        this.expFrame.fileWarning((Warning)new PageNotFoundWarning(WikitextWarning.WarningSeverity.NORMAL, ((Object)((Object)this)).getClass(), n, title));
    }

    private WtNodeList mergeLogsAndWarnings(EngLogContainer log, EngProcessedPage processedPage) {
        if (log != null) {
            log.add((AstNode)processedPage.getLog());
        }
        this.expFrame.addWarnings(processedPage.getWarnings());
        return this.nf.unwrap((AstNodeList)processedPage.getPage());
    }

    private WtNode treatBlockElements(WtTemplate tmpl, WtNode result) {
        if (result != null) {
            return this.treatBlockElements((WtNode)tmpl, result, tmpl.isPrecededByNewline());
        }
        return null;
    }

    private WtNode treatBlockElements(WtNode tmpl, WtNode result, boolean hadNewline) {
        AstTextUtils.PartialConversion split;
        Matcher m;
        if (result != null && !hadNewline && (m = STARTS_WITH_BLOCK_ELEMENT.matcher((split = this.tu.astToTextPartial(result, new int[]{1, 2})).getText())).find()) {
            result = this.nf.list(new Object[]{this.nf.text("\n" + split.getText()), split.getTail()});
        }
        return result;
    }

    private boolean skip(WtNode n) {
        return n.hasAttribute(SKIP_ATTR_NAME);
    }

    private WtNode markError(WtNode n) {
        n.setAttribute(SKIP_ATTR_NAME, (Object)false);
        return n;
    }

    private WtNode markError(WtNode n, Exception e) {
        n.setAttribute(SKIP_ATTR_NAME, (Object)e);
        return n;
    }
}

