/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine;

import org.sweble.wikitext.engine.OffendingNodeWarning;
import org.sweble.wikitext.engine.PageTitle;
import org.sweble.wikitext.parser.WikitextWarning;
import org.sweble.wikitext.parser.nodes.WtNode;

public class PageNotFoundWarning
extends OffendingNodeWarning {
    private static final long serialVersionUID = 1L;
    private final PageTitle title;

    public PageNotFoundWarning(WikitextWarning.WarningSeverity severity, String origin, WtNode titleNode, PageTitle title) {
        super(titleNode, severity, origin, PageNotFoundWarning.makeMessage(title));
        this.title = title;
    }

    public PageNotFoundWarning(WikitextWarning.WarningSeverity severity, Class<?> origin, WtNode titleNode, PageTitle title) {
        super(titleNode, severity, origin, PageNotFoundWarning.makeMessage(title));
        this.title = title;
    }

    private static String makeMessage(PageTitle title) {
        return "The given text `" + title.getDenormalizedFullTitle() + "' " + "does not constitute a valid page name";
    }

    public PageTitle getTitle() {
        return this.title;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PageNotFoundWarning other = (PageNotFoundWarning)((Object)obj);
        return !(this.title == null ? other.title != null : !this.title.equals(other.title));
    }
}

