/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sweble.wikitext.engine.config.Interwiki;
import org.sweble.wikitext.engine.config.Namespace;
import org.sweble.wikitext.engine.config.WikiConfig;
import org.sweble.wikitext.engine.config.WikiConfigurationException;
import org.sweble.wikitext.engine.utils.UrlService;
import org.sweble.wikitext.parser.parser.LinkTargetException;
import org.sweble.wikitext.parser.parser.LinkTargetParser;

public class PageTitle
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final WikiConfig config;
    private final String title;
    private final String fragment;
    private final Namespace namespace;
    private final String namespaceAlias;
    private final Interwiki interwiki;
    private final boolean initialColon;
    private final boolean isDefaultNs;

    public String getTitle() {
        return this.title;
    }

    public String getFragment() {
        return this.fragment;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public String getNamespaceAlias() {
        if (this.namespaceAlias == null) {
            return this.namespace.getName();
        }
        return this.namespaceAlias;
    }

    public Interwiki getInterwikiLink() {
        return this.interwiki;
    }

    public boolean isLocal() {
        return this.interwiki == null;
    }

    public boolean isInterwiki() {
        return !this.isLocal();
    }

    public boolean hasInitialColon() {
        return this.initialColon;
    }

    public String getDenormalizedFullTitle() {
        String result = "";
        if (this.interwiki != null) {
            result = result + this.interwiki.getPrefix() + ":";
        }
        if (this.namespace != null && !this.isDefaultNs) {
            result = result + this.getNamespaceAlias() + ":";
        }
        result = result + this.getDenormalizedTitle();
        return result;
    }

    public String getDenormalizedTitle() {
        return this.title.replace('_', ' ');
    }

    public String getNormalizedFullTitle() {
        String result = "";
        if (this.interwiki != null) {
            result = result + this.interwiki.getPrefix() + ":";
        }
        if (this.namespace != null && !this.isDefaultNs) {
            result = result + this.getNamespaceAlias() + ":";
        }
        result = result + this.title;
        return result;
    }

    public URL getUrl() {
        if (this.interwiki != null) {
            return this.interwiki.getUrl(this);
        }
        try {
            return UrlService.makeUrlToArticle(this.config.getArticlePath(), this);
        }
        catch (MalformedURLException e) {
            throw new WikiConfigurationException(e);
        }
    }

    public URL getUrl(String urlEncodedQuery) throws MalformedURLException {
        return urlEncodedQuery != null ? UrlService.appendQuery(this.getUrl(), urlEncodedQuery) : this.getUrl();
    }

    public URL getUrl(Map<String, String> query) throws MalformedURLException {
        return query != null && !query.isEmpty() ? UrlService.appendQuery(this.getUrl(), query) : this.getUrl();
    }

    public PageTitle getBaseTitle() {
        if (!this.namespace.isCanHaveSubpages()) {
            return this;
        }
        int i = this.title.lastIndexOf(47);
        if (i < 0) {
            return this;
        }
        String baseTitle = this.title.substring(0, i);
        return new PageTitle(this.config, baseTitle, null, this.namespace, this.namespaceAlias, this.interwiki, this.initialColon, this.isDefaultNs);
    }

    public PageTitle newWithNamespace(Namespace ns) {
        return new PageTitle(this.config, this.title, this.fragment, ns, null, this.interwiki, this.initialColon, ns.equals(this.config.getDefaultNamespace()));
    }

    public PageTitle newWithTitle(String title) {
        return new PageTitle(this.config, title, this.fragment, this.namespace, this.namespaceAlias, this.interwiki, this.initialColon, this.isDefaultNs);
    }

    protected PageTitle(WikiConfig config, String title, String fragment, Namespace namespace, String namespaceAlias, Interwiki interwiki, boolean initialColon, boolean isDefaultNs) {
        this.config = config;
        this.title = title;
        this.fragment = fragment;
        this.namespace = namespace;
        this.namespaceAlias = namespaceAlias;
        this.interwiki = interwiki;
        this.initialColon = initialColon;
        this.isDefaultNs = isDefaultNs;
    }

    public static PageTitle make(WikiConfig config, String target) throws LinkTargetException {
        return PageTitle.make(config, target, null);
    }

    public static PageTitle make(WikiConfig config, String target, Namespace defaultNamespace) throws LinkTargetException {
        Interwiki interwiki;
        String lcNs;
        LinkTargetParser parser = new LinkTargetParser();
        parser.parse(config.getParserConfig(), target);
        String title = parser.getTitle();
        String fragment = parser.getFragment();
        boolean initialColon = parser.isInitialColon();
        Namespace namespace = null;
        if (parser.getNamespace() != null) {
            namespace = config.getNamespace(parser.getNamespace());
        }
        if (namespace == null && (namespace = defaultNamespace) == null) {
            namespace = config.getDefaultNamespace();
        }
        String namespaceAlias = null;
        if (namespace != null && parser.getNamespace() != null && !(lcNs = parser.getNamespace().toLowerCase()).equals(namespace.getName())) {
            for (String a : namespace.getAliases()) {
                if (!lcNs.equals(a.toLowerCase())) continue;
                namespaceAlias = a;
                break;
            }
        }
        if ((interwiki = config.getInterwiki(parser.getInterwiki())) == null) {
            title = StringUtils.capitalize((String)title);
        }
        boolean isDefaultNs = namespace.equals(config.getDefaultNamespace());
        return new PageTitle(config, title, fragment, namespace, namespaceAlias, interwiki, initialColon, isDefaultNs);
    }

    public String toString() {
        return this.getDenormalizedFullTitle();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fragment == null ? 0 : this.fragment.hashCode());
        result = 31 * result + (this.initialColon ? 1231 : 1237);
        result = 31 * result + (this.interwiki == null ? 0 : this.interwiki.hashCode());
        result = 31 * result + (this.isDefaultNs ? 1231 : 1237);
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PageTitle other = (PageTitle)obj;
        if (this.fragment == null ? other.fragment != null : !this.fragment.equals(other.fragment)) {
            return false;
        }
        if (this.initialColon != other.initialColon) {
            return false;
        }
        if (this.interwiki == null ? other.interwiki != null : !this.interwiki.equals(other.interwiki)) {
            return false;
        }
        if (this.isDefaultNs != other.isDefaultNs) {
            return false;
        }
        if (this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace)) {
            return false;
        }
        return !(this.title == null ? other.title != null : !this.title.equals(other.title));
    }
}

