/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine;

import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.sweble.wikitext.engine.ExpansionFrame;
import org.sweble.wikitext.engine.PfnArgumentMode;
import org.sweble.wikitext.engine.config.WikiConfig;
import org.sweble.wikitext.engine.nodes.EngineNodeFactory;
import org.sweble.wikitext.engine.utils.EngineAstTextUtils;
import org.sweble.wikitext.parser.nodes.WtNode;

@XmlTransient
@XmlJavaTypeAdapter(value=ParserFunctionAdapter.class)
public abstract class ParserFunctionBase
implements Serializable,
Comparable<ParserFunctionBase> {
    private static final long serialVersionUID = 1L;
    private final String id;
    private final PfnArgumentMode argMode;
    private final boolean pageSwitch;
    private WikiConfig wikiConfig;
    private EngineAstTextUtils tu;
    private EngineNodeFactory nf;

    public ParserFunctionBase(String id) {
        this(PfnArgumentMode.UNEXPANDED_VALUES, false, id);
    }

    public ParserFunctionBase(PfnArgumentMode argMode, String id) {
        this(argMode, false, id);
    }

    public ParserFunctionBase(PfnArgumentMode argMode, boolean pageSwitch, String id) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.argMode = argMode;
        this.pageSwitch = pageSwitch;
        this.id = id;
    }

    public ParserFunctionBase(WikiConfig wikiConfig, String id) {
        this(wikiConfig, PfnArgumentMode.UNEXPANDED_VALUES, false, id);
    }

    public ParserFunctionBase(WikiConfig wikiConfig, PfnArgumentMode argMode, String id) {
        this(wikiConfig, argMode, false, id);
    }

    public ParserFunctionBase(WikiConfig wikiConfig, PfnArgumentMode argMode, boolean pageSwitch, String id) {
        this(argMode, pageSwitch, id);
        this.setWikiConfig(wikiConfig);
    }

    public void setWikiConfig(WikiConfig wikiConfig) {
        if (wikiConfig == null) {
            throw new IllegalArgumentException();
        }
        this.wikiConfig = wikiConfig;
        this.nf = wikiConfig.getNodeFactory();
        this.tu = wikiConfig.getAstTextUtils();
    }

    public WikiConfig getWikiConfig() {
        return this.wikiConfig;
    }

    public String getId() {
        return this.id;
    }

    public PfnArgumentMode getArgMode() {
        return this.argMode;
    }

    public boolean isPageSwitch() {
        return this.pageSwitch;
    }

    protected EngineNodeFactory nf() {
        return this.nf;
    }

    protected EngineAstTextUtils tu() {
        return this.tu;
    }

    public abstract WtNode invoke(WtNode var1, ExpansionFrame var2, List<? extends WtNode> var3);

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    @Override
    public int compareTo(ParserFunctionBase o) {
        return this.id.compareTo(o.getId());
    }

    public String toString() {
        return "ParserFunctionBase [id=" + this.id + ", argMode=" + (Object)((Object)this.argMode) + ", pageSwitch=" + this.pageSwitch + "]";
    }

    public static final class ParserFunctionAdapter
    extends XmlAdapter<ParserFunctionRef, ParserFunctionBase> {
        public ParserFunctionRef marshal(ParserFunctionBase v) throws Exception {
            return new ParserFunctionRef(v.getClass().getName());
        }

        public ParserFunctionBase unmarshal(ParserFunctionRef v) throws Exception {
            Class<?> clazz = Class.forName(v.className);
            return (ParserFunctionBase)clazz.newInstance();
        }
    }

    protected static final class ParserFunctionRef {
        @XmlAttribute(name="class")
        public String className;

        public ParserFunctionRef() {
        }

        public ParserFunctionRef(String name) {
            this.className = name;
        }
    }
}

